/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;

public class TransformerBasedFieldTransformation
extends FieldTransformation {
    protected Class transformerClass;
    protected String transformerClassName;
    protected FieldTransformer transformer;

    public TransformerBasedFieldTransformation() {
    }

    public TransformerBasedFieldTransformation(FieldTransformer aTransformer) {
        this.transformer = aTransformer;
        if (this.transformer != null) {
            this.setTransformerClass(this.transformer.getClass());
            this.setTransformerClassName(this.transformer.getClass().getName());
        }
    }

    public Class getTransformerClass() {
        return this.transformerClass;
    }

    public void setTransformerClass(Class transformerClass) {
        this.transformerClass = transformerClass;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    public FieldTransformer buildTransformer() throws Exception {
        if (this.transformer == null) {
            Class transformerClass = this.getTransformerClass();
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    this.transformer = (FieldTransformer)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(transformerClass));
                }
                catch (PrivilegedActionException ex) {
                    throw (Exception)ex.getCause();
                }
            } else {
                this.transformer = (FieldTransformer)PrivilegedAccessHelper.newInstanceFromClass(transformerClass);
            }
        }
        return this.transformer;
    }
}

