/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.MarshalRecordContentHandler;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Stack nodes;

    public NodeRecord() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xmlPlatform.createDocument();
    }

    public NodeRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public NodeRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        Element rootElement = this.document.createElementNS(rootElementNamespaceURI, rootElementName);
        this.document.appendChild(rootElement);
        this.setDOM(rootElement);
    }

    public NodeRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public NodeRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public NodeRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public NodeRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        return this.getNode().getLocalName();
    }

    public String getNamespaceURI() {
        return this.getNode().getNamespaceURI();
    }

    public void clear() {
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDOM() {
        return (Element)this.nodes.peek();
    }

    private Node getNode() {
        return (Node)this.nodes.peek();
    }

    public void setDOM(Node dom) {
        this.nodes = new Stack();
        if (dom.getNodeType() == 9) {
            this.document = (Document)dom;
        } else if (dom.getNodeType() == 1 || dom.getNodeType() == 11) {
            this.document = dom.getOwnerDocument();
            this.nodes.push(dom);
            this.getNamespaceResolver().setDOM(dom);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void startDocument(String encoding, String version) {
    }

    public void endDocument() {
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            NodeRecordContentHandler mrcHdlr = new NodeRecordContentHandler(this, namespaceResolver);
            XMLFragmentReader xfRdr = new XMLFragmentReader(namespaceResolver);
            xfRdr.setContentHandler(mrcHdlr);
            try {
                xfRdr.parse(node);
            }
            catch (SAXException sex) {
                // empty catch block
            }
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        String namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element = this.getDocument().createElementNS(namespaceURI, xPathFragment.getShortName());
        try {
            this.getNode().appendChild(element);
            this.nodes.push(element);
        }
        catch (Exception e) {
            this.document.appendChild(element);
            this.setDOM(element);
            this.nodes.push(element);
        }
    }

    public void element(String namespaceURI, String localName, String qName) {
        Element element = this.getDocument().createElementNS(namespaceURI, qName);
        this.getNode().appendChild(element);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        String namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(namespaceURI, xPathFragment.getShortName(), value);
        }
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(namespaceURI, qName, value);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.nodes.pop();
    }

    public void characters(String value) {
        Text text = this.getDocument().createTextNode(value);
        this.getNode().appendChild(text);
    }

    public void cdata(String value) {
        CDATASection cdata = this.getDocument().createCDATASection(value);
        this.getNode().appendChild(cdata);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    protected class NodeRecordContentHandler
    extends MarshalRecordContentHandler {
        Map<String, String> prefixMappings;

        public NodeRecordContentHandler(NodeRecord nRec, NamespaceResolver resolver) {
            super(nRec, resolver);
            this.prefixMappings = new HashMap<String, String>();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Element element = namespaceURI == null ? NodeRecord.this.getDocument().createElement(qName) : NodeRecord.this.getDocument().createElementNS(namespaceURI, qName);
            try {
                NodeRecord.this.getNode().appendChild(element);
                NodeRecord.this.nodes.push(element);
            }
            catch (Exception e) {
                NodeRecord.this.document.appendChild(element);
                NodeRecord.this.setDOM(element);
                NodeRecord.this.nodes.push(element);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                this.marshalRecord.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
            }
            if (!this.prefixMappings.isEmpty()) {
                for (String prefix : this.prefixMappings.keySet()) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, this.prefixMappings.get(prefix));
                }
                this.prefixMappings.clear();
            }
            this.marshalRecord.closeStartElement();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = NodeRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }
    }
}

