/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.factory;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.ComponentFactory;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.event.CommandActionListener;
import com.sun.jsftemplating.layout.event.ValueChangeListener;
import com.sun.jsftemplating.util.LogUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;

public abstract class ComponentFactoryBase
implements ComponentFactory {
    private Serializable _extraInfo = null;

    public abstract UIComponent create(FacesContext var1, LayoutComponent var2, UIComponent var3);

    protected void setOptions(FacesContext context, LayoutComponent desc, UIComponent comp) {
        if (desc == null) {
            return;
        }
        String compId = desc.getId(context, comp.getParent());
        if (compId != null && !compId.equals("")) {
            comp.setId(compId);
        }
        Iterator<String> it = desc.getOptions().keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = it.next();
            this.setOption(context, comp, desc, key, desc.getOption(key));
        }
        List<Handler> handlers = desc.getHandlers("command");
        if (handlers != null && comp instanceof ActionSource) {
            ((ActionSource)comp).addActionListener((ActionListener)CommandActionListener.getInstance());
        }
        if ((handlers = desc.getHandlers("valueChange")) != null && comp instanceof EditableValueHolder) {
            ((EditableValueHolder)comp).addValueChangeListener((javax.faces.event.ValueChangeListener)ValueChangeListener.getInstance());
        }
        this.storeInstanceHandlers(desc, comp);
    }

    protected void setOption(FacesContext context, UIComponent comp, LayoutComponent desc, String key, Object value) {
        ComponentUtil.setOption(context, key, value, desc, comp);
    }

    protected void storeInstanceHandlers(LayoutComponent desc, UIComponent comp) {
        UIComponent parent;
        if (!desc.isNested() && ((parent = comp.getParent()) == null || parent instanceof UIViewRoot)) {
            return;
        }
        Iterator<String> it = desc.getHandlersByTypeMap().keySet().iterator();
        if (it.hasNext()) {
            String eventType = null;
            Map compAttrs = comp.getAttributes();
            while (it.hasNext()) {
                eventType = it.next();
                if (eventType.equals("beforeCreate") || eventType.equals("afterCreate")) continue;
                compAttrs.put(eventType, desc.getHandlers(eventType));
            }
        }
    }

    protected void addChild(FacesContext context, LayoutComponent descriptor, UIComponent parent, UIComponent child) {
        String facetName = descriptor.getFacetName(parent);
        if (facetName != null) {
            if (LogUtil.configEnabled() && facetName.equals("_noname")) {
                LogUtil.config("Warning: no id was supplied for component '" + child + "'!");
            }
            facetName = (String)ComponentUtil.resolveValue(context, descriptor, child, facetName);
            parent.getFacets().put(facetName, child);
        } else {
            parent.getChildren().add(child);
        }
    }

    protected UIComponent createComponent(FacesContext ctx, String componentType, LayoutComponent desc, UIComponent parent) {
        UIComponent comp = null;
        String binding = null;
        if (desc != null) {
            binding = (String)desc.getEvaluatedOption(ctx, "binding", parent);
        }
        if (binding != null && ComponentUtil.isValueReference(binding)) {
            ValueExpression ve = ctx.getApplication().getExpressionFactory().createValueExpression(ctx.getELContext(), binding, UIComponent.class);
            comp = ctx.getApplication().createComponent(ve, ctx, componentType);
        } else {
            comp = ctx.getApplication().createComponent(componentType);
        }
        if (parent != null) {
            this.addChild(ctx, desc, parent, comp);
        }
        return comp;
    }

    public Serializable getExtraInfo() {
        return this._extraInfo;
    }

    public void setExtraInfo(Serializable extraInfo) {
        this._extraInfo = extraInfo;
    }
}

