/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import java.io.IOException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class LayoutMarkup
extends LayoutElementBase
implements LayoutElement {
    private static final long serialVersionUID = 1L;
    public static final HandlerDefinition afterEncodeHandlerDef = new HandlerDefinition("_markupAfterEncode");
    public static final Handler afterEncodeHandler = new Handler(afterEncodeHandlerDef);
    public static final String TYPE_BOTH = "both";
    public static final String TYPE_CLOSE = "close";
    public static final String TYPE_OPEN = "open";
    private String _tag = null;
    private String _type = null;

    public LayoutMarkup(LayoutElement parent, String tag, String type) {
        super(parent, tag);
        this._tag = tag;
        this._type = type;
        if (!type.equals(TYPE_OPEN)) {
            ArrayList<Handler> handlers = new ArrayList<Handler>();
            handlers.add(afterEncodeHandler);
            this.setHandlers("afterEncode", handlers);
        }
    }

    public String getTag() {
        return this._tag;
    }

    public String getType() {
        return this._type;
    }

    protected boolean encodeThis(FacesContext context, UIComponent component) throws IOException {
        if (this.getType().equals(TYPE_CLOSE)) {
            return true;
        }
        ResponseWriter writer = context.getResponseWriter();
        Object value = this.resolveValue(context, component, this.getTag());
        if (value != null) {
            writer.startElement(value.toString(), component);
        }
        return true;
    }

    public static void afterEncodeHandler(HandlerContext context) throws IOException {
        ResponseWriter writer = context.getFacesContext().getResponseWriter();
        LayoutMarkup markup = (LayoutMarkup)context.getLayoutElement();
        Object value = ComponentUtil.resolveValue(context.getFacesContext(), markup, (UIComponent)context.getEventObject().getSource(), markup.getTag());
        if (value != null) {
            writer.endElement(value.toString());
        }
    }

    static {
        afterEncodeHandlerDef.setHandlerMethod(LayoutMarkup.class.getName(), "afterEncodeHandler");
    }
}

