/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.layout.template.CustomParserCommand;
import com.sun.jsftemplating.layout.template.NameValuePair;
import com.sun.jsftemplating.layout.template.ProcessingContext;
import com.sun.jsftemplating.layout.template.ProcessingContextEnvironment;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.template.TemplateReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;

public class EventParserCommand
implements CustomParserCommand {
    public static final String IF_HANDLER = "if";
    public static final String CONDITION_ATTRIBUTE = "condition";
    public static final char LEFT_CURLY = '{';
    public static final char RIGHT_CURLY = '}';

    public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String eventName) throws IOException {
        Handler handler = null;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        TemplateReader reader = env.getReader();
        TemplateParser parser = reader.getTemplateParser();
        Handler parentHandler = null;
        Stack<Handler> handlerStack = new Stack<Handler>();
        parser.skipCommentsAndWhiteSpace(" \t\r\n");
        int ch = parser.nextChar();
        while (ch != -1 && ch != 47 && ch != 62) {
            if (ch == 123 || ch == 125) {
                if (ch == 123) {
                    handlerStack.push(parentHandler);
                    parentHandler = handler;
                } else {
                    if (handlerStack.empty()) {
                        throw new SyntaxException("Encountered unmatched '}' when parsing handlers for '" + eventName + "' event.");
                    }
                    parentHandler = (Handler)handlerStack.pop();
                }
                parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
                ch = parser.nextChar();
                continue;
            }
            parser.unread(ch);
            handler = this.readHandler(parser, eventName);
            if (parentHandler == null) {
                handlers.add(handler);
            } else {
                parentHandler.addChildHandler(handler);
            }
            ch = parser.nextChar();
        }
        if (ch == -1) {
            throw new SyntaxException("Unexpected EOF encountered while parsing handlers for event '" + eventName + "'!");
        }
        if (!handlerStack.empty()) {
            throw new SyntaxException("Unmatched '{' when parsing handlers for '" + eventName + "' event.");
        }
        if (ch == 62) {
            throw new SyntaxException("Handlers for event '" + eventName + "' did not end with '/&gt;' but instead ended with '&gt;'!");
        }
        if (ch == 47) {
            parser.skipCommentsAndWhiteSpace(" \t\r\n");
            ch = parser.nextChar();
            if (ch != 62) {
                throw new SyntaxException("Expected '/&gt;' a end of '" + eventName + "' event.  But found '/" + (char)ch + "'.");
            }
            reader.popTag();
            ctx.endSpecial(env, eventName);
        }
        env.getParent().setHandlers(eventName, handlers);
    }

    private Handler readHandler(TemplateParser parser, String eventName) throws IOException {
        String target = null;
        String defVal = null;
        NameValuePair nvp = null;
        HandlerDefinition def = null;
        String handlerId = parser.readToken();
        def = LayoutDefinitionManager.getGlobalHandlerDefinition(handlerId);
        if (def == null) {
            throw new SyntaxException("Handler '" + handlerId + "' in event '" + eventName + "' is not declared!  " + "Ensure the '@Handler' annotation has been defined " + "on the handler Java method, that it has been " + "compiled with the annotation processing tool, and " + "that the resulting" + " 'META-INF/jsftemplating/Handler.map' is located " + "in your classpath (you may need to do a clean " + "build).");
        }
        Handler handler = new Handler(def);
        Map<String, IODescriptor> inputs = def.getInputDefs();
        if (inputs.size() == 1) {
            defVal = inputs.keySet().toArray()[0].toString();
        }
        parser.skipCommentsAndWhiteSpace(" \t\r\n");
        int ch = parser.nextChar();
        if (ch != 40) {
            throw new SyntaxException("While processing '&lt;!" + eventName + "...' the handler '" + handlerId + "' was missing the '(' character!");
        }
        parser.skipWhiteSpace(" \t\r\n");
        ch = parser.nextChar();
        if (ch != 35 || !handlerId.equals(IF_HANDLER)) {
            parser.unread(ch);
            parser.skipCommentsAndWhiteSpace("");
            ch = parser.nextChar();
        }
        if (handlerId.equals(IF_HANDLER) && ch != 39 && ch != 34 && ch != 99) {
            parser.unread(ch);
            handler.setCondition(parser.readUntil(41, false).trim());
            ch = 41;
        }
        while (ch != -1 && ch != 41) {
            parser.unread(ch);
            try {
                nvp = parser.getNVP(defVal);
            }
            catch (SyntaxException ex) {
                throw new SyntaxException("Unable to process handler '" + handlerId + "'!", ex);
            }
            parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
            ch = parser.nextChar();
            target = nvp.getTarget();
            if (target != null) {
                handler.setOutputMapping(nvp.getName(), nvp.getValue().toString(), target);
                continue;
            }
            String name = nvp.getName();
            if (name.equals(CONDITION_ATTRIBUTE) && (inputs.get(CONDITION_ATTRIBUTE) == null || handlerId.equals(IF_HANDLER))) {
                handler.setCondition(nvp.getValue().toString());
                continue;
            }
            handler.setInputValue(nvp.getName(), nvp.getValue());
        }
        parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
        return handler;
    }
}

