/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.RegistrationData;
import com.sun.servicetag.Registry;
import com.sun.servicetag.ServiceTag;
import com.sun.servicetag.SolarisServiceTag;
import com.sun.servicetag.SunConnection;
import com.sun.servicetag.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    private static String SVCTAG_DIR_PATH = "servicetag.dir.path";
    private static String SVCTAG_ENABLE_REGISTRATION = "servicetag.registration.enabled";
    private static final String SUN_VENDOR = "Sun Microsystems";
    private static final String REGISTRATION_XML = "registration.xml";
    private static final String SERVICE_TAG_FILE = "servicetag";
    private static final String REGISTRATION_HTML_NAME = "register";
    private static final Locale[] knownSupportedLocales = new Locale[]{Locale.ENGLISH, Locale.JAPANESE, Locale.SIMPLIFIED_CHINESE};
    private static final String javaHome = System.getProperty("java.home");
    private static File svcTagDir;
    private static File serviceTagFile;
    private static File regXmlFile;
    private static RegistrationData registration;
    private static boolean supportRegistration;
    private static String registerHtmlParent;
    private static Set<Locale> supportedLocales;
    private static Properties swordfishProps;
    private static String[] jreArchs;
    private static final String JDK_HEADER_PNG_KEY = "@@JDK_HEADER_PNG@@";
    private static final String JDK_VERSION_KEY = "@@JDK_VERSION@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    private Installer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceTag getJavaServiceTag(String source) throws IOException {
        if (!System.getProperty("java.vendor").startsWith(SUN_VENDOR)) {
            return null;
        }
        boolean cleanup = false;
        try {
            if (Installer.loadSwordfishEntries() == null) {
                ServiceTag serviceTag = null;
                return serviceTag;
            }
            ServiceTag st = Installer.getJavaServiceTag();
            if (st != null && st.getSource().equals(source)) {
                if (Registry.isSupported()) {
                    Installer.installSystemServiceTag();
                }
                ServiceTag serviceTag = st;
                return serviceTag;
            }
            cleanup = true;
            Installer.deleteRegistrationData();
            cleanup = false;
            ServiceTag serviceTag = Installer.createServiceTag(source);
            return serviceTag;
        }
        finally {
            if (cleanup) {
                if (regXmlFile.exists()) {
                    regXmlFile.delete();
                }
                if (serviceTagFile.exists()) {
                    serviceTagFile.delete();
                }
            }
        }
    }

    private static synchronized RegistrationData getRegistrationData() throws IOException {
        if (registration != null) {
            return registration;
        }
        if (regXmlFile.exists()) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(regXmlFile));
                registration = RegistrationData.loadFromXML(in);
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Error: Bad registration data \"" + regXmlFile + "\":" + ex.getMessage());
                throw ex;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        } else {
            registration = new RegistrationData();
        }
        return registration;
    }

    private static synchronized void writeRegistrationXml() throws IOException {
        if (!svcTagDir.exists() && !svcTagDir.mkdir()) {
            throw new IOException("Failed to create directory: " + svcTagDir);
        }
        Installer.deleteRegistrationHtmlPage();
        Installer.getRegistrationHtmlPage();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(regXmlFile));
            Installer.getRegistrationData().storeToXML(out);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Error: Bad registration data \"" + regXmlFile + "\":" + ex.getMessage());
            throw ex;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getInstalledURNs() throws IOException {
        HashSet<String> urnSet = new HashSet<String>();
        if (serviceTagFile.exists()) {
            BufferedReader in = null;
            try {
                String urn;
                in = new BufferedReader(new FileReader(serviceTagFile));
                while ((urn = in.readLine()) != null) {
                    if ((urn = urn.trim()).length() <= 0) continue;
                    urnSet.add(urn);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return urnSet;
    }

    private static ServiceTag[] getJavaServiceTagArray() throws IOException {
        RegistrationData regData = Installer.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        HashSet<ServiceTag> result = new HashSet<ServiceTag>();
        Properties props = Installer.loadSwordfishEntries();
        String jdkUrn = props.getProperty("servicetag.jdk.urn");
        String jreUrn = props.getProperty("servicetag.jre.urn");
        for (ServiceTag st : svcTags) {
            if (!st.getProductURN().equals(jdkUrn) && !st.getProductURN().equals(jreUrn)) continue;
            result.add(st);
        }
        return result.toArray(new ServiceTag[0]);
    }

    private static ServiceTag getJavaServiceTag() throws IOException {
        String definedId = Installer.getProductDefinedId();
        for (ServiceTag st : Installer.getJavaServiceTagArray()) {
            if (!st.getProductDefinedInstanceID().equals(definedId)) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag createServiceTag(String svcTagSource) throws IOException {
        ServiceTag newSvcTag = null;
        if (Installer.getJavaServiceTag() == null) {
            newSvcTag = Installer.newServiceTag(svcTagSource);
        }
        if (newSvcTag != null) {
            RegistrationData regData = Installer.getRegistrationData();
            newSvcTag = regData.addServiceTag(newSvcTag);
            ServiceTag osTag = SolarisServiceTag.getServiceTag();
            if (osTag != null && regData.getServiceTag(osTag.getInstanceURN()) == null) {
                regData.addServiceTag(osTag);
            }
            Installer.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            Installer.installSystemServiceTag();
        }
        return newSvcTag;
    }

    private static void installSystemServiceTag() throws IOException {
        if (!serviceTagFile.exists() && !svcTagDir.canWrite() || serviceTagFile.exists() && !serviceTagFile.canWrite()) {
            return;
        }
        Set<String> urns = Installer.getInstalledURNs();
        ServiceTag[] javaSvcTags = Installer.getJavaServiceTagArray();
        if (urns.size() < javaSvcTags.length) {
            for (ServiceTag st : javaSvcTags) {
                String instanceURN = st.getInstanceURN();
                if (urns.contains(instanceURN)) continue;
                Registry.getSystemRegistry().addServiceTag(st);
            }
        }
        Installer.writeInstalledUrns();
    }

    private static ServiceTag newServiceTag(String svcTagSource) throws IOException {
        String productName;
        String productURN;
        Properties props = Installer.loadSwordfishEntries();
        if (Util.isJdk()) {
            productURN = props.getProperty("servicetag.jdk.urn");
            productName = props.getProperty("servicetag.jdk.name");
        } else {
            productURN = props.getProperty("servicetag.jre.urn");
            productName = props.getProperty("servicetag.jre.name");
        }
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, System.getProperty("java.version"), productURN, props.getProperty("servicetag.parent.name"), props.getProperty("servicetag.parent.urn"), Installer.getProductDefinedId(), SUN_VENDOR, System.getProperty("os.arch"), Installer.getZoneName(), svcTagSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteRegistrationData() throws IOException {
        try {
            Installer.deleteRegistrationHtmlPage();
            Set<String> urns = Installer.getInstalledURNs();
            if (urns.size() > 0 && Registry.isSupported()) {
                for (String u : urns) {
                    Registry.getSystemRegistry().removeServiceTag(u);
                }
            }
            registration = null;
        }
        finally {
            if (regXmlFile.exists() && !regXmlFile.delete()) {
                throw new IOException("Failed to delete " + regXmlFile);
            }
            if (serviceTagFile.exists() && !serviceTagFile.delete()) {
                throw new IOException("Failed to delete " + serviceTagFile);
            }
        }
    }

    private static synchronized void updateRegistrationData(String svcTagSource) throws IOException {
        RegistrationData regData = Installer.getRegistrationData();
        ServiceTag curSvcTag = Installer.newServiceTag(svcTagSource);
        ServiceTag[] javaSvcTags = Installer.getJavaServiceTagArray();
        Set<String> urns = Installer.getInstalledURNs();
        for (ServiceTag st : javaSvcTags) {
            if (st.getProductDefinedInstanceID().equals(curSvcTag.getProductDefinedInstanceID())) continue;
            String instanceURN = st.getInstanceURN();
            regData.removeServiceTag(instanceURN);
            if (!urns.contains(instanceURN) || !Registry.isSupported()) continue;
            Registry.getSystemRegistry().removeServiceTag(instanceURN);
        }
        Installer.writeRegistrationXml();
        Installer.writeInstalledUrns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInstalledUrns() throws IOException {
        if (!Registry.isSupported() && serviceTagFile.exists()) {
            serviceTagFile.delete();
            return;
        }
        PrintWriter out = null;
        try {
            ServiceTag[] javaSvcTags;
            out = new PrintWriter(serviceTagFile);
            for (ServiceTag st : javaSvcTags = Installer.getJavaServiceTagArray()) {
                String instanceURN = st.getInstanceURN();
                out.println(instanceURN);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Properties loadSwordfishEntries() throws IOException {
        if (swordfishProps != null) {
            return swordfishProps;
        }
        int version = Util.getJdkVersion();
        String filename = "/com/sun/servicetag/resources/javase_" + version + "_swordfish.properties";
        InputStream in = Installer.class.getClass().getResourceAsStream(filename);
        if (in == null) {
            return null;
        }
        swordfishProps = new Properties();
        try {
            swordfishProps.load(in);
        }
        finally {
            in.close();
        }
        return swordfishProps;
    }

    private static String getProductDefinedId() {
        String[] archs;
        StringBuilder definedId = new StringBuilder();
        definedId.append("id=");
        definedId.append(System.getProperty("java.runtime.version"));
        for (String name : archs = Installer.getJreArchs()) {
            definedId.append(" " + name);
        }
        String location = ",dir=" + javaHome;
        if (definedId.length() + location.length() < 256) {
            definedId.append(",dir=");
            definedId.append(javaHome);
        } else if (Util.isVerbose()) {
            System.err.println("Warning: Product defined instance ID exceeds the field limit:");
        }
        return definedId.toString();
    }

    private static synchronized String[] getJreArchs() {
        if (jreArchs != null) {
            return jreArchs;
        }
        HashSet<String> archs = new HashSet<String>();
        String os = System.getProperty("os.name");
        if (os.equals("SunOS") || os.equals("Linux")) {
            File dir = new File(Util.getJrePath() + File.separator + "lib");
            if (dir.isDirectory()) {
                String[] children;
                for (String name : children = dir.list()) {
                    File f = new File(dir, name + File.separator + "libjava.so");
                    if (!f.exists()) continue;
                    archs.add(name);
                }
            }
        } else {
            archs.add(System.getProperty("os.arch"));
        }
        jreArchs = archs.toArray(new String[0]);
        return jreArchs;
    }

    private static String getZoneName() throws IOException {
        String zonename = "global";
        String command = "/usr/bin/zonename";
        File f = new File(command);
        if (f.exists()) {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            if (p.exitValue() == 0) {
                zonename = output.trim();
            }
        }
        return zonename;
    }

    private static synchronized String getRegisterHtmlParent() throws IOException {
        if (registerHtmlParent == null) {
            File htmlDir = Util.getJrePath().endsWith(File.separator + "jre") ? new File(Util.getJrePath(), "..") : new File(Util.getJrePath());
            Installer.initSupportedLocales(htmlDir);
            String path = System.getProperty(SVCTAG_DIR_PATH);
            if (path == null) {
                registerHtmlParent = htmlDir.getCanonicalPath();
            } else {
                File f = new File(path);
                registerHtmlParent = f.getCanonicalPath();
                if (!f.isDirectory()) {
                    throw new InternalError("Path " + path + " set in \"" + SVCTAG_DIR_PATH + "\" property is not a directory");
                }
            }
        }
        return registerHtmlParent;
    }

    static synchronized File getRegistrationHtmlPage() throws IOException {
        if (!supportRegistration) {
            return null;
        }
        String parent = Installer.getRegisterHtmlParent();
        File f = new File(parent, "register.html");
        if (!f.exists()) {
            Installer.generateRegisterHtml(parent);
        }
        String name = REGISTRATION_HTML_NAME;
        List<Locale> candidateLocales = Installer.getCandidateLocales(Locale.getDefault());
        for (Locale l : candidateLocales) {
            if (!supportedLocales.contains(l)) continue;
            name = "register_" + l.toString();
            break;
        }
        File htmlFile = new File(parent, name + ".html");
        if (Util.isVerbose()) {
            System.out.print("Offline registration page: " + htmlFile);
            System.out.println(htmlFile.exists() ? "" : " not exist. Use register.html");
        }
        if (htmlFile.exists()) {
            return htmlFile;
        }
        return new File(parent, "register.html");
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<Locale> locales = new ArrayList<Locale>(3);
        if (variant.length() > 0) {
            locales.add(locale);
        }
        if (country.length() > 0) {
            locales.add(locales.size() == 0 ? locale : new Locale(language, country, ""));
        }
        if (language.length() > 0) {
            locales.add(locales.size() == 0 ? locale : new Locale(language, "", ""));
        }
        return locales;
    }

    private static void deleteRegistrationHtmlPage() throws IOException {
        String parent = Installer.getRegisterHtmlParent();
        if (parent == null) {
            return;
        }
        for (Locale locale : supportedLocales) {
            File f;
            String name = REGISTRATION_HTML_NAME;
            if (!locale.equals(Locale.ENGLISH)) {
                name = name + "_" + locale.toString();
            }
            if (!(f = new File(parent, name + ".html")).exists() || f.delete()) continue;
            throw new IOException("Failed to delete " + f);
        }
    }

    private static void initSupportedLocales(File jdkDir) {
        String[] readmes;
        if (supportedLocales.isEmpty()) {
            for (Locale l : knownSupportedLocales) {
                supportedLocales.add(l);
            }
        }
        FilenameFilter ff = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String fname = name.toLowerCase();
                return fname.startsWith("readme") && fname.endsWith(".html");
            }
        };
        block6: for (String name : readmes = jdkDir.list(ff)) {
            String basename = name.substring(0, name.length() - ".html".length());
            String[] ss = basename.split("_");
            switch (ss.length) {
                case 1: {
                    continue block6;
                }
                case 2: {
                    supportedLocales.add(new Locale(ss[1]));
                    continue block6;
                }
                case 3: {
                    supportedLocales.add(new Locale(ss[1], ss[2]));
                    continue block6;
                }
            }
        }
        if (Util.isVerbose()) {
            System.out.println("Supported locales: ");
            for (Locale l : supportedLocales) {
                System.out.println(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateRegisterHtml(String parent) throws IOException {
        int version = Util.getJdkVersion();
        int update = Util.getUpdateVersion();
        String jdkVersion = "Version " + version;
        if (update > 0) {
            jdkVersion = jdkVersion + " Update " + update;
        }
        RegistrationData regData = Installer.getRegistrationData();
        String registerURL = SunConnection.getRegistrationURL(regData.getRegistrationURN()).toString();
        File img = new File(svcTagDir.getCanonicalPath(), "jdk_header.png");
        String headerImageSrc = img.toURI().toString();
        StringBuilder payload = new StringBuilder();
        String xml = regData.toString().replaceAll("\"", "%22");
        BufferedReader reader = new BufferedReader(new StringReader(xml));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                payload.append(line.trim());
            }
        }
        finally {
            reader.close();
        }
        String resourceFilename = "/com/sun/servicetag/resources/register";
        for (Locale locale : supportedLocales) {
            String name = REGISTRATION_HTML_NAME;
            String resource = resourceFilename;
            if (!locale.equals(Locale.ENGLISH)) {
                name = name + "_" + locale.toString();
                resource = resource + "_" + locale.toString();
            }
            File f = new File(parent, name + ".html");
            InputStream in = null;
            BufferedReader br = null;
            PrintWriter pw = null;
            try {
                in = Installer.class.getClass().getResourceAsStream(resource + ".html");
                if (in == null) {
                    if (!Util.isVerbose()) continue;
                    System.out.println("Missing resouce file: " + resource + ".html");
                    continue;
                }
                if (Util.isVerbose()) {
                    System.out.println("Generating " + f + " from " + resource + ".html");
                }
                br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                pw = new PrintWriter(f, "UTF-8");
                String line = null;
                while ((line = br.readLine()) != null) {
                    String output = line;
                    if (line.contains(JDK_VERSION_KEY)) {
                        output = line.replace(JDK_VERSION_KEY, jdkVersion);
                    } else if (line.contains(JDK_HEADER_PNG_KEY)) {
                        output = line.replace(JDK_HEADER_PNG_KEY, headerImageSrc);
                    } else if (line.contains(REGISTRATION_URL_KEY)) {
                        output = line.replace(REGISTRATION_URL_KEY, registerURL);
                    } else if (line.contains(REGISTRATION_PAYLOAD_KEY)) {
                        output = line.replace(REGISTRATION_PAYLOAD_KEY, payload.toString());
                    }
                    pw.println(output);
                }
                f.setReadOnly();
                pw.flush();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (in != null) {
                    in.close();
                }
                if (br == null) continue;
                br.close();
            }
        }
    }

    public static void main(String[] args) {
        block20: {
            String source = "Manual";
            boolean delete = false;
            boolean update = false;
            boolean register = false;
            int count = 0;
            while (count < args.length) {
                String arg = args[count];
                if (arg.trim().length() == 0) {
                    ++count;
                    continue;
                }
                if (arg.equals("-source")) {
                    source = args[++count];
                } else if (arg.equals("-delete")) {
                    delete = true;
                } else if (arg.equals("-register")) {
                    register = true;
                } else {
                    Installer.usage();
                    return;
                }
                ++count;
            }
            try {
                if (delete) {
                    Installer.deleteRegistrationData();
                } else {
                    String[] archs;
                    ServiceTag[] javaSvcTags = Installer.getJavaServiceTagArray();
                    if (javaSvcTags.length > (archs = Installer.getJreArchs()).length) {
                        Installer.updateRegistrationData(source);
                    } else {
                        Installer.createServiceTag(source);
                    }
                }
                if (register) {
                    RegistrationData regData = Installer.getRegistrationData();
                    if (supportRegistration && !regData.getServiceTags().isEmpty()) {
                        SunConnection.register(regData);
                    }
                }
                System.exit(0);
            }
            catch (IOException e) {
                System.err.println("I/O Error: " + e.getMessage());
                if (Util.isVerbose()) {
                    e.printStackTrace();
                }
            }
            catch (IllegalArgumentException ex) {
                if (Util.isVerbose()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                if (!Util.isVerbose()) break block20;
                e.printStackTrace();
            }
        }
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.print("    " + Installer.class.getName());
        System.out.println(" [-delete|-source <source>|-register]");
        System.out.println("       to create a service tag for the Java platform");
        System.out.println("");
        System.out.println("Internal Options:");
        System.out.println("    -source: to specify the source of the service tag to be created");
        System.out.println("    -delete: to delete the service tag ");
        System.out.println("    -register: to register the JDK");
        System.out.println("    -help:   to print this help message");
    }

    static {
        supportedLocales = new HashSet<Locale>();
        swordfishProps = null;
        jreArchs = null;
        String dir = System.getProperty(SVCTAG_DIR_PATH);
        svcTagDir = dir == null ? new File(Util.getJrePath(), "lib" + File.separator + SERVICE_TAG_FILE) : new File(dir);
        serviceTagFile = new File(svcTagDir, SERVICE_TAG_FILE);
        regXmlFile = new File(svcTagDir, REGISTRATION_XML);
        supportRegistration = System.getProperty(SVCTAG_ENABLE_REGISTRATION) == null ? Util.isJdk() : true;
    }
}

