/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.appserv.management.config.ApplicationConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppHandlers {
    private static Map<String, String> displayMap = new HashMap<String, String>();

    public static void getApplicationInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String appType = (String)handlerCtx.getInputValue("appType");
        AMXRoot amxRoot = AMXRoot.getInstance();
        ApplicationConfig appConfig = (ApplicationConfig)amxRoot.getApplicationsConfig().getApplicationConfigMap().get(name);
        if (appConfig == null) {
            System.out.println("!!!!!! Error: Cannot find application with the name: " + name);
            return;
        }
        handlerCtx.setOutputValue("contextRoot", (Object)appConfig.getContextRoot());
        if (!amxRoot.supportCluster()) {
            handlerCtx.setOutputValue("vs", (Object)TargetUtil.getAssociatedVS((String)name, (String)"server"));
        }
        handlerCtx.setOutputValue("location", (Object)appConfig.getLocation());
        handlerCtx.setOutputValue("description", (Object)appConfig.getDescription());
        if (amxRoot.isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)appConfig, (boolean)true));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isApplicationEnabled((Enabled)appConfig, (String)"server"));
        }
        if (!"connector".equals(appType)) {
            handlerCtx.setOutputValue("libraries", (Object)appConfig.getLibraries());
        }
    }

    public static void saveApplicationInfo(HandlerContext handlerCtx) {
        String target = "server";
        String name = (String)handlerCtx.getInputValue("name");
        String appType = (String)handlerCtx.getInputValue("appType");
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            ApplicationConfig appConfig = (ApplicationConfig)amxRoot.getApplicationsConfig().getApplicationConfigMap().get(name);
            if (appConfig == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchApplication"));
                return;
            }
            appConfig.setContextRoot((String)handlerCtx.getInputValue("contextRoot"));
            if (amxRoot.isEE()) {
                appConfig.setAvailabilityEnabled((String)handlerCtx.getInputValue("availEnabled"));
            } else {
                String vs = (String)handlerCtx.getInputValue("vs");
                TargetUtil.setVirtualServers((String)name, (String)"server", (String)vs);
            }
            appConfig.setDescription((String)handlerCtx.getInputValue("description"));
            if (!amxRoot.isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setApplicationEnabled((Enabled)appConfig, (String)"server", (boolean)enabled);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getDeployedWebInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        Map webAppsConfig = AMXUtil.getApplicationConfigByType((String)"web");
        ArrayList result = new ArrayList();
        for (ApplicationConfig appConfig : webAppsConfig.values()) {
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String protocol = "http";
            String enable = TargetUtil.getEnabledStatus((Enabled)appConfig, (boolean)true);
            oneRow.put("name", appConfig.getName());
            oneRow.put("enabled", enable);
            String contextRoot = appConfig.getContextRoot();
            oneRow.put("contextRoot", contextRoot);
            String port = WebAppHandlers.getPortForApplication(appConfig.getName());
            if (port == null) {
                oneRow.put("port", "");
                oneRow.put("hasLaunch", false);
            } else {
                if (port.startsWith("-")) {
                    protocol = "https";
                    port = port.substring(1);
                }
                oneRow.put("port", port);
                if (AMXRoot.getInstance().isEE()) {
                    if (enable.equals(GuiUtil.getMessage((String)"deploy.allDisabled")) || enable.equals(GuiUtil.getMessage((String)"deploy.noTarget"))) {
                        oneRow.put("hasLaunch", false);
                    } else {
                        oneRow.put("hasLaunch", true);
                    }
                } else {
                    oneRow.put("hasLaunch", Boolean.parseBoolean(enable));
                    String ctxRoot = WebAppHandlers.calContextRoot(contextRoot);
                    oneRow.put("launchLink", protocol + "://" + serverName + ":" + port + ctxRoot);
                }
            }
            oneRow.put("selected", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getAppTypeForDisplay(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        handlerCtx.setOutputValue("displayType", (Object)displayMap.get(appType));
    }

    protected String getHost(ObjectName serverInstance) {
        return "";
    }

    public static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    private static String getPortForApplication(String appName) {
        String vsId;
        DeployedItemRefConfig appRef = TargetUtil.getDeployedItemRefObject((String)appName, (String)"server");
        HTTPListenerConfig listener = null;
        listener = appRef == null ? WebAppHandlers.getListener() : ((vsId = TargetUtil.getAssociatedVS((String)appName, (String)"server")) == null || vsId.length() == 0 ? WebAppHandlers.getListener() : WebAppHandlers.getListener(vsId));
        if (listener == null) {
            return null;
        }
        String port = listener.getPort();
        String security = listener.getSecurityEnabled();
        return "true".equals(security) ? "-" + port : port;
    }

    private static HTTPListenerConfig getListener() {
        Map vsMap = AMXRoot.getInstance().getConfig("server-config").getHTTPServiceConfig().getVirtualServerConfigMap();
        return WebAppHandlers.getOneVsWithHttpListener(new ArrayList<String>(vsMap.keySet()));
    }

    private static HTTPListenerConfig getListener(String vsIds) {
        return WebAppHandlers.getOneVsWithHttpListener(GuiUtil.parseStringList((String)vsIds, (String)","));
    }

    private static HTTPListenerConfig getOneVsWithHttpListener(List<String> vsList) {
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        HTTPListenerConfig secureListener = null;
        HTTPServiceConfig hConfig = AMXRoot.getInstance().getConfig("server-config").getHTTPServiceConfig();
        Map vsMap = hConfig.getVirtualServerConfigMap();
        for (String vsName : vsList) {
            VirtualServerConfig vs;
            String listener;
            if (vsName.equals("__asadmin") || GuiUtil.isEmpty((String)(listener = (vs = (VirtualServerConfig)vsMap.get(vsName)).getHTTPListeners()))) continue;
            List hpList = GuiUtil.parseStringList((String)listener, (String)",");
            for (String one : hpList) {
                HTTPListenerConfig oneListener = (HTTPListenerConfig)hConfig.getHTTPListenerConfigMap().get(one);
                if (!"true".equals(oneListener.getEnabled())) continue;
                String security = oneListener.getSecurityEnabled();
                if ("true".equals(security)) {
                    secureListener = oneListener;
                    continue;
                }
                return oneListener;
            }
        }
        return secureListener;
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }

    static {
        displayMap.put("application", GuiUtil.getMessage((String)"deploy.ear"));
        displayMap.put("webApp", GuiUtil.getMessage((String)"deploy.war"));
        displayMap.put("ejbModule", GuiUtil.getMessage((String)"deploy.ejb"));
        displayMap.put("appclient", GuiUtil.getMessage((String)"deploy.appClient"));
        displayMap.put("connector", GuiUtil.getMessage((String)"deploy.rar"));
    }
}

