/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.appserv.management.config.ApplicationConfig;
import com.sun.appserv.management.config.EngineConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXUtil {
    public static String getPropertyValue(PropertiesAccess mbean, String key) {
        return AMXUtil.getPropertyValue(mbean, key, "");
    }

    public static String getPropertyValue(PropertiesAccess mbean, String key, String defaultValue) {
        if (mbean.getPropertyConfigMap().get(key) != null) {
            defaultValue = ((PropertyConfig)mbean.getPropertyConfigMap().get(key)).getValue();
        }
        return defaultValue;
    }

    public static String getPropValue(Map<String, PropertyConfig> propMap, String key) {
        if (propMap.get(key) != null) {
            return propMap.get(key).getValue();
        }
        return "";
    }

    public static void setPropertyValue(PropertiesAccess config, String propName, String propValue) {
        Map pMap = config.getPropertyConfigMap();
        if (pMap.containsKey(propName)) {
            if (GuiUtil.isEmpty(propValue)) {
                config.removePropertyConfig(propName);
            } else {
                PropertyConfig cp = (PropertyConfig)config.getPropertyConfigMap().get(propName);
                if (!cp.getValue().equals(propValue)) {
                    cp.setValue(propValue);
                }
            }
        } else if (!GuiUtil.isEmpty(propValue)) {
            config.createPropertyConfig(propName, propValue);
        }
    }

    public static void updateProperties(PropertiesAccess config, Map<String, String> newProps) {
        AMXUtil.updateProperties(config, newProps, null);
    }

    public static void updateProperties(PropertiesAccess config, Map<String, String> newProps, List ignore) {
        Map oldProps = config.getPropertyConfigMap();
        if (ignore == null) {
            ignore = new ArrayList();
        }
        for (Object key : oldProps.keySet()) {
            if (ignore.contains(key) || newProps.containsKey(key)) continue;
            config.removePropertyConfig((String)key);
        }
        Map pMap = config.getPropertyConfigMap();
        for (String propName : newProps.keySet()) {
            String propValue = newProps.get(propName);
            if (pMap.containsKey(propName)) {
                ((PropertyConfig)pMap.get(propName)).setValue(propValue);
                continue;
            }
            config.createPropertyConfig(propName, propValue);
        }
    }

    public static Map convertToPropertiesOptionMap(Map<String, String> props, Map<String, String> convertedMap) {
        if (convertedMap == null) {
            convertedMap = new HashMap<String, String>();
        }
        if (props == null) {
            return convertedMap;
        }
        Set<String> keySet = props.keySet();
        for (String key : keySet) {
            if (GuiUtil.isEmpty(props.get(key))) continue;
            convertedMap.put("property." + key, props.get(key));
        }
        return convertedMap;
    }

    public static Map<String, PropertyConfig> getNonSkipPropertiesMap(PropertiesAccess config, List skipList) {
        Map props = config.getPropertyConfigMap();
        HashMap<String, PropertyConfig> newMap = new HashMap<String, PropertyConfig>();
        for (String propsName : props.keySet()) {
            if (skipList.contains(propsName)) continue;
            newMap.put(propsName, (PropertyConfig)props.get(propsName));
        }
        return newMap;
    }

    public static void putOptionalValue(String value, Map convertedMap, String propName) {
        if (GuiUtil.isEmpty(value)) {
            return;
        }
        convertedMap.put("property." + propName, value);
    }

    public static boolean isAppType(ApplicationConfig testApp, String type) {
        Map engineConfigMap = testApp.getEngineConfigMap();
        for (EngineConfig eConfig : engineConfigMap.values()) {
            String sniffer = eConfig.getSniffer();
            if (!sniffer.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, ApplicationConfig> getApplicationConfigByType(String type) {
        HashMap<String, ApplicationConfig> result = new HashMap<String, ApplicationConfig>();
        Map appConfigMap = AMXRoot.getInstance().getApplicationsConfig().getApplicationConfigMap();
        for (ApplicationConfig aConfig : appConfigMap.values()) {
            if (!AMXUtil.isAppType(aConfig, type)) continue;
            result.put(aConfig.getName(), aConfig);
        }
        return result;
    }

    public static ApplicationConfig getApplicationConfigByName(String name) {
        ApplicationConfig appConfig = (ApplicationConfig)AMXRoot.getInstance().getApplicationsConfig().getApplicationConfigMap().get(name);
        return appConfig;
    }
}

