/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.amx.dotted.AttrPart;
import org.glassfish.admin.amx.dotted.DottedNameStrings;
import org.glassfish.admin.amx.dotted.PathPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParsedV3Pathname {
    private final boolean mIsFullPath;
    private final List<PathPart> mParts;
    private final AttrPart mAttr;

    private static void cdebug(String s) {
        System.out.println(s);
    }

    public ParsedV3Pathname(boolean fullPath, List<PathPart> parts) {
        this(fullPath, parts, null);
    }

    public ParsedV3Pathname(boolean fullPath, List<PathPart> parts, AttrPart attrPart) {
        for (PathPart part : parts) {
            ParsedV3Pathname.cdebug("checkLegalNamePart: " + part.getType());
            this.checkLegalNamePart(part.getType());
            if (part.getName() == null) continue;
            ParsedV3Pathname.cdebug("checkLegalNamePart: " + part.getName());
            this.checkLegalNamePart(part.getName());
        }
        this.mParts = parts;
        this.mAttr = attrPart;
        this.mIsFullPath = fullPath;
    }

    static ParsedV3Pathname parse(String sourceString) {
        String[] splits;
        boolean isFullPath;
        int idx = sourceString.indexOf(64);
        if (idx == 0) {
            throw new IllegalArgumentException(sourceString);
        }
        String attr = null;
        String path = null;
        if (idx < 0) {
            path = sourceString;
        } else {
            path = sourceString.substring(0, idx);
            attr = sourceString.substring(idx + 1, sourceString.length());
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(sourceString);
        }
        boolean bl = isFullPath = path.indexOf(47) == 0;
        if (isFullPath) {
            path = path.substring(1, path.length());
        }
        ParsedV3Pathname.cdebug("fullpath = " + isFullPath + ", path = " + path + ", attr = " + attr);
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        for (String s : splits = path.split("/")) {
            parts.add(new PathPart(s));
            ParsedV3Pathname.cdebug("part: /" + s);
        }
        AttrPart attrPart = attr == null ? null : new AttrPart(attr);
        ParsedV3Pathname.cdebug("attrPart = " + attrPart);
        ParsedV3Pathname parsed = new ParsedV3Pathname(isFullPath, parts, attrPart);
        ParsedV3Pathname.cdebug("ParsedV3Pathname = " + parsed);
        return parsed;
    }

    public List<PathPart> getParts() {
        return this.mParts;
    }

    public AttrPart getAttrPart() {
        return this.mAttr;
    }

    public boolean isFullPath() {
        return this.mIsFullPath;
    }

    boolean isLegalChar(char theChar) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.\\*".indexOf(theChar) >= 0;
    }

    void checkLegalChar(char theChar) {
        if (!this.isLegalChar(theChar)) {
            String msg = DottedNameStrings.getString("IllegalCharacter", "'" + theChar + "'");
            throw new IllegalArgumentException(msg);
        }
    }

    void checkLegalNamePart(String part) {
        int length = part.length();
        if (length == 0) {
            String msg = DottedNameStrings.getString("MissingExpectedNamePart");
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < length; ++i) {
            char theChar = part.charAt(i);
            this.checkLegalChar(theChar);
        }
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 37 * hashcode + ((Object)this.mParts).hashCode();
        if (this.mAttr != null) {
            hashcode ^= this.mAttr.hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        equals = !(other instanceof ParsedV3Pathname) ? false : (other == this ? true : this.toString().equals(other.toString()));
        return equals;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (PathPart part : this.mParts) {
            buf.append('/');
            buf.append(part.toString());
        }
        if (this.mAttr != null) {
            buf.append('@');
            buf.append(this.mAttr.toString());
        }
        return buf.toString();
    }
}

