/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMXDebugSupportMBean;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.jmx.stringifier.StringifierRegistryIniter;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.stringifier.StringifierRegistryImpl;
import com.sun.appserv.management.util.stringifier.StringifierRegistryIniterImpl;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.relation.MBeanServerNotificationFilter;
import org.glassfish.admin.amx.loader.BootUtil;
import org.glassfish.admin.amx.loader.LoaderMBean;
import org.glassfish.admin.amx.loader.LoaderRegHandler;
import org.glassfish.admin.amx.mbean.MBeanImplBase;
import org.glassfish.admin.amx.mbean.SystemInfoFactory;
import org.glassfish.admin.amx.mbean.SystemInfoImpl;
import org.glassfish.admin.amx.util.AMXDebugSupport;
import org.glassfish.admin.amx.util.ObjectNames;

abstract class LoaderBase
extends MBeanImplBase
implements LoaderMBean,
LoaderRegHandler {
    protected volatile boolean mStarted;
    protected final ObjectNames mObjectNames;
    private static LoaderMBean LOADER = null;

    public LoaderBase() {
        this.debug((Object)"LoaderBase");
        boolean offline = false;
        BootUtil.init(false);
        this.mServer = null;
        new StringifierRegistryIniterImpl(StringifierRegistryImpl.DEFAULT);
        new StringifierRegistryIniter(StringifierRegistryImpl.DEFAULT);
        this.mStarted = false;
        this.mObjectNames = ObjectNames.getInstance(this.getAMXJMXDomainName());
    }

    public String getAMXJMXDomainName() {
        return BootUtil.getInstance().getAMXJMXDomainName();
    }

    public String getAdministrativeDomainName() {
        return BootUtil.getInstance().getAppserverDomainName();
    }

    public void handleNotification(Notification notifIn, Object handback) {
    }

    public void handleMBeanRegistered(ObjectName oldObjectName) throws InstanceNotFoundException {
    }

    public void handleMBeanUnregistered(ObjectName oldObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
    }

    protected static long now() {
        return System.currentTimeMillis();
    }

    protected final ObjectName loadSystemInfo(MBeanServer server) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        this.debug((Object)"loadSystemInfo");
        SystemInfoImpl systemInfo = SystemInfoFactory.createInstance(server);
        ObjectName tempName = this.mObjectNames.getSingletonObjectName("X-SystemInfo");
        ObjectName objectName = this.mServer.registerMBean(systemInfo, tempName).getObjectName();
        this.debug((Object)"loaded SystemInfo");
        return objectName;
    }

    public final ObjectName preRegister(MBeanServer server, ObjectName objectNameIn) throws Exception {
        this.debug((Object)"preRegister");
        ObjectName superObjectName = super.preRegister(server, objectNameIn);
        String domain = BootUtil.getInstance().getAMXSupportJMXDomain();
        this.mSelfObjectName = Util.newObjectName((String)domain, (String)"name=mbean-loader");
        try {
            MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
            filter.enableAllObjectNames();
            if (this.mServer != server) {
                throw new IllegalStateException();
            }
            JMXUtil.listenToMBeanServerDelegate((MBeanServerConnection)this.mServer, (NotificationListener)this, (NotificationFilter)filter, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.debug((Object)("preRegister done: " + this.mSelfObjectName));
        return this.mSelfObjectName;
    }

    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            LoaderBase.initLOADER(this.getMBeanServer(), this.getObjectName());
            this.start();
        }
    }

    protected boolean mySleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            interrupted = true;
        }
        return interrupted;
    }

    protected void startHook() {
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    protected abstract Object createDomainRoot();

    public abstract boolean isDAS();

    private final void loadDomainRoot() {
        this.debug((Object)"loadDomainRoot ENTER");
        Object domainRoot = this.createDomainRoot();
        if (domainRoot != null) {
            ObjectName objectName = this.mObjectNames.getDomainRootObjectName();
            this.debug((Object)("Registering DomainRoot, impl class = " + domainRoot.getClass().getName()));
            try {
                objectName = this.mServer.registerMBean(domainRoot, objectName).getObjectName();
                this.loadSystemInfo(this.mServer);
                this.debug((Object)("Registered DomainRoot: " + objectName));
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                this.debug((Object)("Exception loading DomainRoot: " + rootCause + ", msg=" + rootCause.getMessage()));
                throw new RuntimeException(rootCause);
            }
        } else {
            this.debug((Object)"loadDomainRoot: NULL");
        }
        this.debug((Object)"loadDomainRoot DONE");
    }

    public final DomainRoot getDomainRoot() {
        ProxyFactory factory = ProxyFactory.getInstance((MBeanServer)this.getMBeanServer());
        return factory.getDomainRoot();
    }

    private static void initLOADER(MBeanServer server, ObjectName loaderObjectName) {
        assert (LOADER == null);
        try {
            MBeanServerConnectionSource conn = new MBeanServerConnectionSource(server);
            MBeanProxyHandler handler = new MBeanProxyHandler((ConnectionSource)conn, loaderObjectName);
            LOADER = (LoaderMBean)Proxy.newProxyInstance(LoaderMBean.class.getClassLoader(), new Class[]{LoaderMBean.class}, (InvocationHandler)handler);
        }
        catch (IOException e) {
            assert (false) : "can't happen";
            throw new RuntimeException(e);
        }
    }

    public static LoaderMBean getLoader(MBeanServer server) {
        return LOADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        LoaderBase loaderBase = this;
        synchronized (loaderBase) {
            if (this.mStarted) {
                throw new IllegalArgumentException("Can't start Loader twice");
            }
            this.mStarted = true;
        }
        try {
            AMXDebugSupport dbg = new AMXDebugSupport(this.mServer);
            this.mServer.registerMBean(new StandardMBean(dbg, AMXDebugSupportMBean.class), AMXDebugSupport.getObjectName());
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            this.debug((Object)("Exception loading AMXDebugSupport: " + rootCause + ", msg=" + rootCause.getMessage()));
            throw new RuntimeException(rootCause);
        }
        this.loadDomainRoot();
        this.startHook();
        new CheckStartedThread().start();
    }

    public ObjectName sync(ObjectName name) {
        throw new UnsupportedOperationException("sync");
    }

    public ObjectName resyncAMXMBean(ObjectName amx) throws InstanceNotFoundException, MBeanRegistrationException {
        return amx;
    }

    private final class CheckStartedThread
    extends Thread {
        private CheckStartedThread() {
        }

        public void CheckStartedThread() {
        }

        public void run() {
            long AMX_READY_SLEEP_DURATION = 100L;
            while (!LoaderBase.this.isStarted()) {
                LoaderBase.this.debug("Waiting 100ms for AMX to start");
                LoaderBase.this.sleepMillis(100L);
            }
            BootUtil.getInstance().setAMXReady(true);
        }
    }
}

