/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.Sample;
import com.sun.appserv.management.util.jmx.JMXUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;

public final class SampleImpl
extends AMXNonConfigImplBase {
    private final Map<String, Serializable> mAttributes = Collections.synchronizedMap(new HashMap());
    private MBeanInfo mMBeanInfo = null;
    private static final int MEGABYTE = 0x100000;

    public void emitNotifications(Serializable data, int numNotifs, long interval) {
        if (numNotifs <= 0) {
            throw new IllegalArgumentException("" + numNotifs);
        }
        new EmitterThread(data, numNotifs, interval).start();
    }

    public SampleImpl(ObjectName parentObjectName) {
        super("X-Sample", "X-Sample", parentObjectName, Sample.class, null);
    }

    public void addAttribute(String name, Serializable value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(name, value);
        this.mMBeanInfo = null;
    }

    public void removeAttribute(String name) {
        this.mAttributes.remove(name);
        this.mMBeanInfo = null;
    }

    public boolean getMBeanInfoIsInvariant() {
        return false;
    }

    private synchronized MBeanInfo createMBeanInfo() {
        MBeanInfo baseMBeanInfo = super.getMBeanInfo();
        MBeanAttributeInfo[] dynamicAttrInfos = new MBeanAttributeInfo[this.mAttributes.keySet().size()];
        Iterator<String> iter = this.mAttributes.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name = iter.next();
            Serializable value = this.mAttributes.get(name);
            String type = value == null ? String.class.getName() : value.getClass().getName();
            dynamicAttrInfos[i] = new MBeanAttributeInfo(name, type, "dynamically-added Attribute", true, true, false);
            ++i;
        }
        MBeanAttributeInfo[] attrInfos = JMXUtil.mergeMBeanAttributeInfos((MBeanAttributeInfo[])dynamicAttrInfos, (MBeanAttributeInfo[])baseMBeanInfo.getAttributes());
        return JMXUtil.newMBeanInfo((MBeanInfo)baseMBeanInfo, (MBeanAttributeInfo[])attrInfos);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mMBeanInfo == null) {
            this.mMBeanInfo = this.createMBeanInfo();
        }
        return this.mMBeanInfo;
    }

    protected Serializable getAttributeManually(String name) {
        return this.mAttributes.get(name);
    }

    protected void setAttributeManually(Attribute attr) {
        this.mAttributes.put(attr.getName(), (Serializable)Serializable.class.cast(attr.getValue()));
    }

    public void uploadBytes(byte[] bytes) {
    }

    public byte[] downloadBytes(int numBytes) {
        if (numBytes < 0 || numBytes > 0xA00000) {
            throw new IllegalArgumentException("Illegal count: " + numBytes);
        }
        byte[] bytes = new byte[numBytes];
        return bytes;
    }

    private final class EmitterThread
    extends Thread {
        private final Serializable mData;
        private final int mNumNotifs;
        private final long mIntervalMillis;

        public EmitterThread(Serializable data, int numNotifs, long intervalMillis) {
            this.mData = data;
            this.mNumNotifs = numNotifs;
            this.mIntervalMillis = intervalMillis;
        }

        public void run() {
            for (int i = 0; i < this.mNumNotifs; ++i) {
                SampleImpl.this.sendNotification("Sample", "UserData", this.mData);
                try {
                    Thread.sleep(this.mIntervalMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

