/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner
extends JavaEEScanner
implements Scanner {
    File directory;
    Set<String> entries = new HashSet<String>();
    ClassLoader classLoader = null;

    public void process(File directory, Object bundleDesc, ClassLoader classLoader) throws IOException {
        AnnotationUtils.getLogger().finer("dir is " + directory);
        AnnotationUtils.getLogger().finer("classLoader is " + classLoader);
        this.directory = directory;
        this.classLoader = classLoader;
        this.init(directory);
    }

    private void init(File directory) throws IOException {
        this.init(directory, directory);
    }

    private void init(File top, File directory) throws IOException {
        File[] subDirs;
        File[] dirFiles;
        for (File file : dirFiles = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".class");
            }
        })) {
            this.entries.add(file.getPath().substring(top.getPath().length() + 1));
        }
        for (File subDir : subDirs = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.init(top, subDir);
        }
    }

    protected Set<String> getEntries() {
        return this.entries;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = new URL[1];
            try {
                urls[0] = this.directory.getAbsoluteFile().toURL();
                this.classLoader = new URLClassLoader(urls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String fileName : this.entries) {
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length() - 6);
            System.out.println("Getting " + className);
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (Throwable cnfe) {
                AnnotationUtils.getLogger().severe("cannot load " + className + " reason : " + cnfe.getMessage());
            }
        }
        return elements;
    }
}

