/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.config.JRubyConfig;
import com.sun.grizzly.jruby.config.JRubyRuntimeConfig;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JRubyConfigImpl
implements JRubyConfig {
    private final String jrubyHome;
    private final String railsRoot;
    private final String contextRoot;
    private final String environment;
    private final String appType;
    private boolean mtSafe = false;
    private final String gemPath;
    private JRubyRuntimeConfig runtimeConfig;
    private final Logger logger;

    public JRubyConfigImpl(Properties props, String railsRoot, String contextRoot, Logger logger) {
        this.logger = logger;
        this.railsRoot = railsRoot;
        this.contextRoot = contextRoot;
        String home = props.getProperty("jruby.home");
        File f = new File(home);
        try {
            home = f.getCanonicalPath();
        }
        catch (IOException e) {
            home = f.getAbsolutePath();
        }
        this.jrubyHome = home;
        String re = System.getProperty("rails.env");
        if (re == null) {
            re = props.getProperty("jruby.rackEnv");
        }
        if (re == null) {
            re = System.getenv("RAILS_ENV");
        }
        this.environment = re == null ? "development" : re;
        logger.info("Environment: " + this.environment);
        this.appType = props.getProperty("jruby.applicationType") == null ? System.getProperty("jruby.applicationType") : props.getProperty("jruby.applicationType");
        String val = props.getProperty("jruby.MTSafe");
        if (val == null) {
            val = System.getProperty("jruby.MTSafe");
        }
        this.mtSafe = Boolean.valueOf(val);
        this.gemPath = System.getenv("GEM_PATH") == null ? System.getProperty("gem.path") : "";
        int numRt = 1;
        int numMinRt = -1;
        int numMaxRt = -1;
        String jrubyRuntime = System.getProperty("jruby.runtime");
        String jrubyMinRuntime = System.getProperty("jruby.runtime.min");
        String jrubyMaxRuntime = System.getProperty("jruby.runtime.max");
        try {
            if (props.getProperty("jruby.runtime") != null) {
                numRt = this.toInt(props.getProperty("jruby.runtime"), "jruby.runtime");
            } else if (jrubyRuntime != null) {
                numRt = this.toInt(jrubyRuntime, "jruby.runtime");
            }
            if (props.getProperty("jruby.runtime.min") != null) {
                numMinRt = this.toInt(props.getProperty("jruby.runtime.min"), "jruby.runtime.min");
            } else if (jrubyMinRuntime != null) {
                numMinRt = this.toInt(jrubyMinRuntime, "jruby.runtime.min");
            }
            if (props.getProperty("jruby.runtime.max") != null) {
                numMaxRt = this.toInt(props.getProperty("jruby.runtime.max"), "jruby.runtime.max");
            } else if (jrubyMaxRuntime != null) {
                numMaxRt = this.toInt(jrubyMaxRuntime, "jruby.runtime.max");
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        final int minRuntime = numMinRt;
        final int maxRuntime = numMaxRt;
        final int numberOfRuntime = numRt;
        this.runtimeConfig = new JRubyRuntimeConfig(){

            public int getInitRuntime() {
                return numberOfRuntime;
            }

            public int getMinRuntime() {
                return minRuntime;
            }

            public int getMaxRuntime() {
                return maxRuntime;
            }
        };
    }

    private int toInt(String value, String propName) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            this.logger.log(Level.WARNING, Messages.format("runtimes.invalid", value, propName), ex);
            throw ex;
        }
    }

    public String jrubyHome() {
        return this.jrubyHome;
    }

    public String appRoot() {
        return this.railsRoot;
    }

    public String contextRoot() {
        return this.contextRoot;
    }

    public String environment() {
        return this.environment;
    }

    public String applicationType() {
        return this.appType;
    }

    public String gemPath() {
        return this.gemPath;
    }

    public boolean isMTSafe() {
        return this.mtSafe;
    }

    public JRubyRuntimeConfig runtimeConfig() {
        return this.runtimeConfig;
    }
}

