/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.GenericApplicationFactory;
import com.sun.grizzly.jruby.rack.MerbApplicationFactory;
import com.sun.grizzly.jruby.rack.MultiThreadedRackAdapter;
import com.sun.grizzly.jruby.rack.RackAdapter;
import com.sun.grizzly.jruby.rack.RailsApplicationFactory;
import com.sun.grizzly.jruby.rack.SinatraApplicationFactory;
import com.sun.grizzly.jruby.rack.SingleThreadedRackAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;

public class RackApplicationChooser {
    public static RackAdapter getFactory(String appPath, RackGrizzlyAdapter adapter) {
        File appFile;
        RackAdapter rack;
        Logger theLog = adapter.getLogger();
        String appType = adapter.config.applicationType();
        if (appType != null) {
            rack = RackApplicationChooser.handleUserSpecifiedFramework(adapter, appPath, appType, theLog);
            if (rack != null) {
                return rack;
            }
            rack = RackApplicationChooser.handleUserSpecifiedStartupScript(appType, adapter, theLog);
            if (rack != null) {
                return rack;
            }
        }
        if (appPath.endsWith(".rb") && (rack = RackApplicationChooser.detectSinatra(appFile = new File(appPath), theLog, adapter)) != null) {
            return rack;
        }
        theLog.fine("Path is " + appPath + ", checking for Rails");
        rack = RackApplicationChooser.detectRails(appPath, theLog, adapter);
        if (rack != null) {
            return rack;
        }
        theLog.fine("Rails not found, checking for Merb");
        rack = RackApplicationChooser.detectMerb(appPath, theLog, adapter);
        if (rack != null) {
            return rack;
        }
        theLog.fine("Merb not found, checking for Sinatra");
        rack = RackApplicationChooser.findSinatra(appPath, theLog, adapter);
        if (rack != null) {
            return rack;
        }
        theLog.info("Unable to find a supported framework! Checking for .ru files");
        String rackUp = RackApplicationChooser.findRackup(appPath);
        if (rackUp != null) {
            theLog.info("Discovered a .ru file, attempting to launch a framework from that.");
            rack = RackApplicationChooser.handleUserSpecifiedStartupScript(rackUp, adapter, theLog);
            if (rack != null) {
                return rack;
            }
        }
        SelectorThread.logger().severe("Framework autodetection failed! Please set -Djruby.rackup_script to the path to a script that will start your framework");
        throw new IllegalStateException("No framework to start!");
    }

    private static String inhale(File f, Logger theLog) {
        String app = "";
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    app = app + s + "\n";
                }
            }
            catch (IOException e) {
                theLog.severe("IO Exception determining framework for " + f.getAbsolutePath() + ": " + e);
            }
        } else {
            theLog.severe("Was told to read nonexistant file " + f.getAbsolutePath());
        }
        return app;
    }

    private static RackAdapter findSinatra(String appPath, Logger theLog, RackGrizzlyAdapter adapter) {
        File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".rb")) continue;
                theLog.fine("Checking " + file.getName());
                RackAdapter rack = RackApplicationChooser.detectSinatra(file, theLog, adapter);
                if (rack == null) continue;
                theLog.fine("Found Sinatra in " + file.getAbsolutePath());
                return rack;
            }
        }
        return null;
    }

    private static String findRackup(String appPath) {
        File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".ru")) continue;
                return file.getPath();
            }
        }
        return null;
    }

    private static RackAdapter handleUserSpecifiedFramework(RackGrizzlyAdapter adapter, String appPath, String appType, Logger theLog) {
        if (appType.equalsIgnoreCase("rails")) {
            RailsApplicationFactory myFactory = new RailsApplicationFactory(adapter);
            if (adapter.config.isMTSafe()) {
                theLog.info("User has specified rails in threadsafe mode, initializing multithreaded rails");
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
            theLog.info("User has specified rails in non-threadsafe mode, initializing pooled rails");
            return new SingleThreadedRackAdapter(myFactory, adapter);
        }
        if (appType.equalsIgnoreCase("merb")) {
            theLog.info("User has specified merb, initializing merb");
            MerbApplicationFactory myFactory = new MerbApplicationFactory(adapter);
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        if (appType.equalsIgnoreCase("sinatra")) {
            theLog.info("User has specified Sinatra, locating Sinatra file and initializing");
            if (appPath.endsWith(".rb")) {
                SinatraApplicationFactory myFactory = new SinatraApplicationFactory(adapter, appPath);
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
            RackAdapter sinatra = RackApplicationChooser.findSinatra(appPath, theLog, adapter);
            if (sinatra != null) {
                theLog.info("Found Sinatra in " + sinatra + ", launching");
                return sinatra;
            }
            theLog.severe("User specified a Sinatra application, but no sinatra application was found in the deployment directory. Falling back to autodetection");
        } else {
            theLog.severe("Unknown framework specified as appType, falling back to autodetection");
        }
        return null;
    }

    private static RackAdapter handleUserSpecifiedStartupScript(String rackUp, RackGrizzlyAdapter adapter, Logger theLog) {
        GenericApplicationFactory myFactory = new GenericApplicationFactory(rackUp, adapter);
        if (adapter.config.isMTSafe()) {
            theLog.info("Running a user-provided rackup script in thread-safe mode");
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        theLog.info("Running a user-provided rackup script in pooled mode");
        return new SingleThreadedRackAdapter(myFactory, adapter);
    }

    private static RackAdapter detectSinatra(File appFile, Logger theLog, RackGrizzlyAdapter adapter) {
        theLog.fine("attempting to detect sinatra in " + appFile.getPath());
        String app = RackApplicationChooser.inhale(appFile, theLog);
        if (app.contains("require 'sinatra'")) {
            SinatraApplicationFactory myFactory = new SinatraApplicationFactory(adapter, appFile.getPath());
            theLog.info("Detected Sinatra application");
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        return null;
    }

    private static RackAdapter detectRails(String appPath, Logger theLog, RackGrizzlyAdapter adapter) {
        String bootFile;
        File boot = new File(appPath, "config/boot.rb");
        if (boot.exists() && (bootFile = RackApplicationChooser.inhale(boot, theLog)).contains("RAILS_ROOT")) {
            RailsApplicationFactory myFactory = new RailsApplicationFactory(adapter);
            theLog.info("Detected Rails application");
            boolean multithreaded = false;
            String environment = "";
            if ("development".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/development.rb"), theLog);
            } else if ("production".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/production.rb"), theLog);
            } else if ("testing".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/testing.rb"), theLog);
            }
            if (environment.matches("(?s)(?m).*^[^#]*config\\.threadsafe!.*")) {
                multithreaded = true;
            }
            if (multithreaded) {
                theLog.info("config.threadsafe sighted! All hands prepare for multithread mode!");
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
            theLog.info("Rails not in thread-safe mode, starting in single-thread mode");
            return new SingleThreadedRackAdapter(myFactory, adapter);
        }
        return null;
    }

    private static RackAdapter detectMerb(String appPath, Logger theLog, RackGrizzlyAdapter adapter) {
        File init = new File(appPath, "config/init.rb");
        if (!init.exists() && !(init = new File(appPath, "root/init.rb")).exists()) {
            return null;
        }
        String initFile = RackApplicationChooser.inhale(init, theLog);
        if (initFile.contains("Merb::Config")) {
            MerbApplicationFactory myFactory = new MerbApplicationFactory(adapter);
            theLog.info("Detected merb application");
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        return null;
    }
}

