/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.util.ClassCache;

class RubyRuntimeFactory {
    private int created = 1;
    private final boolean isJRubyInstanceProvided = System.getProperties().get("jruby.runtime.instance") != null;

    public Ruby makeRubyRuntime(String jrubyHome) {
        Ruby rt;
        if (this.isJRubyInstanceProvided && this.created == 1) {
            rt = (Ruby)System.getProperties().get("jruby.runtime.instance");
        } else {
            RubyInstanceConfig config = new RubyInstanceConfig();
            ArrayList<String> libs = new ArrayList<String>();
            libs.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
            try {
                String binjruby = RubyInstanceConfig.class.getResource("/META-INF/jruby.home/bin/jruby").getFile();
                config.setJRubyHome(binjruby.substring(0, binjruby.length() - 10));
            }
            catch (Exception e) {
                config.setJRubyHome(jrubyHome);
            }
            ClassCache cache = new ClassCache(RubyRuntimeFactory.class.getClassLoader());
            config.setLoader(RubyRuntimeFactory.class.getClassLoader());
            config.setClassCache(cache);
            rt = JavaEmbedUtils.initialize(libs, (RubyInstanceConfig)config);
        }
        rt.defineReadonlyVariable("$runtimeNumber", JavaEmbedUtils.javaToRuby((Ruby)rt, (int)this.created));
        ++this.created;
        return rt;
    }
}

