/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class DescriptorArchivist {
    @Inject
    protected ArchivistFactory archivistFactory;

    public void write(Application application, ReadableArchive in, WritableArchive out) throws IOException {
        if (application.isVirtual()) {
            ModuleDescriptor<BundleDescriptor> aModule = application.getModules().iterator().next();
            Archivist moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
            this.write(aModule.getDescriptor(), moduleArchivist, in, out);
        } else {
            for (ModuleDescriptor<BundleDescriptor> aModule : application.getModules()) {
                Archivist moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
                if (aModule.getAlternateDescriptor() != null) {
                    String ddPath = aModule.getAlternateDescriptor();
                    DeploymentDescriptorFile<BundleDescriptor> ddFile = moduleArchivist.getStandardDDFile();
                    BundleDescriptor bundle = aModule.getDescriptor();
                    if (!bundle.isFullFlag()) {
                        if (ddFile != null) {
                            OutputStream os = out.putNextEntry(ddPath);
                            ddFile.write(bundle, os);
                            out.closeEntry();
                        }
                    } else if (aModule.getModuleType().equals(ModuleType.WAR)) {
                        WebBundleDescriptor webBundle = (WebBundleDescriptor)aModule.getDescriptor();
                        if (webBundle.hasWebServices()) {
                            if (ddFile != null) {
                                OutputStream os = out.putNextEntry(ddPath);
                                ddFile.write(webBundle, os);
                                out.closeEntry();
                            }
                        } else {
                            moduleArchivist.copyAnEntry(in, out, ddPath);
                        }
                    } else {
                        moduleArchivist.copyAnEntry(in, out, ddPath);
                    }
                    String runtimeDDPath = "sun-" + ddPath;
                    DeploymentDescriptorFile confDDFile = moduleArchivist.getConfigurationDDFile();
                    if (confDDFile == null) continue;
                    OutputStream os = out.putNextEntry(runtimeDDPath);
                    confDDFile.write(aModule.getDescriptor(), os);
                    out.closeEntry();
                    continue;
                }
                WritableArchive moduleArchive = out.createSubArchive(aModule.getArchiveUri());
                ReadableArchive moduleArchive2 = in.getSubArchive(aModule.getArchiveUri());
                this.write(aModule.getDescriptor(), moduleArchivist, moduleArchive2, moduleArchive);
            }
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.setDescriptor(application);
            archivist.writeRuntimeDeploymentDescriptors(out);
            if (application.isLoadedFromApplicationXml()) {
                archivist.copyStandardDeploymentDescriptors(in, out);
            } else {
                archivist.writeStandardDeploymentDescriptors(out);
            }
        }
    }

    public void write(BundleDescriptor bundle, ReadableArchive in, WritableArchive out) throws IOException {
        Archivist archivist = this.archivistFactory.getArchivist(in, bundle.getClassLoader());
        this.write(bundle, archivist, in, out);
    }

    protected void write(BundleDescriptor bundle, Archivist archivist, ReadableArchive in, WritableArchive out) throws IOException {
        archivist.setDescriptor(bundle);
        archivist.writeRuntimeDeploymentDescriptors(out);
        if (!bundle.isFullFlag()) {
            archivist.writeStandardDeploymentDescriptors(out);
        } else if (bundle.getModuleType().equals(ModuleType.WAR)) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundle;
            if (webBundle.hasWebServices()) {
                archivist.writeStandardDeploymentDescriptors(out);
            } else {
                archivist.copyStandardDeploymentDescriptors(in, out);
            }
        } else {
            archivist.copyStandardDeploymentDescriptors(in, out);
        }
        if (bundle.hasWebServices()) {
            WebServicesDescriptor webServices = bundle.getWebServices();
            for (WebService webService : webServices.getWebServices()) {
                if (!webService.hasMappingFile() || webService.getMappingFileUri().endsWith(".xml")) continue;
                archivist.copyAnEntry(in, out, webService.getMappingFileUri());
            }
        }
    }
}

