/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import javax.persistence.PersistenceContextType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityManagerReferenceNode
extends DeploymentDescriptorNode {
    private static final String TRANSACTION = "Transaction";
    private static final String EXTENDED = "Extended";
    private String propertyName = null;

    public EntityManagerReferenceNode() {
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("persistence-context-ref-name", "setName");
        table.put("persistence-unit-name", "setUnitName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("persistence-context-type".equals(element.getQName())) {
            EntityManagerReferenceDescriptor entityMgrReferenceDescriptor = (EntityManagerReferenceDescriptor)this.getDescriptor();
            PersistenceContextType contextType = null;
            if (EXTENDED.equals(value)) {
                contextType = PersistenceContextType.EXTENDED;
            } else if (TRANSACTION.equals(value)) {
                contextType = PersistenceContextType.TRANSACTION;
            } else {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.node.invalidvalue", "Invalid value for a tag under {0} : {1}", new Object[]{"persistence-context-type", value}));
            }
            entityMgrReferenceDescriptor.setPersistenceContextType(contextType);
        } else if ("name".equals(element.getQName())) {
            this.propertyName = value;
        } else if ("value".equals(element.getQName())) {
            EntityManagerReferenceDescriptor entityMgrReferenceDescriptor = (EntityManagerReferenceDescriptor)this.getDescriptor();
            entityMgrReferenceDescriptor.addProperty(this.propertyName, value);
            this.propertyName = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EntityManagerReferenceDescriptor descriptor) {
        Element entityMgrRefNode = EntityManagerReferenceNode.appendChild(parent, nodeName);
        this.writeLocalizedDescriptions(entityMgrRefNode, descriptor);
        EntityManagerReferenceNode.appendTextChild((Node)entityMgrRefNode, "persistence-context-ref-name", descriptor.getName());
        EntityManagerReferenceNode.appendTextChild((Node)entityMgrRefNode, "persistence-unit-name", descriptor.getUnitName());
        PersistenceContextType contextType = descriptor.getPersistenceContextType();
        String contextTypeString = contextType != null && PersistenceContextType.EXTENDED.equals((Object)contextType) ? EXTENDED : TRANSACTION;
        EntityManagerReferenceNode.appendTextChild((Node)entityMgrRefNode, "persistence-context-type", contextTypeString);
        for (Map.Entry<String, String> property : descriptor.getProperties().entrySet()) {
            Element propertyNode = EntityManagerReferenceNode.appendChild(entityMgrRefNode, "persistence-property");
            EntityManagerReferenceNode.appendTextChild((Node)propertyNode, "name", property.getKey());
            EntityManagerReferenceNode.appendTextChild((Node)propertyNode, "value", property.getValue());
        }
        if (descriptor.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : descriptor.getInjectionTargets()) {
                ijNode.writeDescriptor((Node)entityMgrRefNode, "injection-target", target);
            }
        }
        return entityMgrRefNode;
    }
}

