/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;
import java.util.Map;
import org.w3c.dom.Node;

public class BeanCacheNode
extends DeploymentDescriptorNode {
    protected BeanCacheDescriptor descriptor = null;

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new BeanCacheDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("is-cache-overflow-allowed".equals(element.getQName())) {
            this.descriptor.setIsCacheOverflowAllowed(Boolean.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    protected Map getDispatchTable() {
        Map dispatchTable = super.getDispatchTable();
        dispatchTable.put("max-cache-size", "setMaxCacheSize");
        dispatchTable.put("resize-quantity", "setResizeQuantity");
        dispatchTable.put("cache-idle-timeout-in-seconds", "setCacheIdleTimeoutInSeconds");
        dispatchTable.put("removal-timeout-in-seconds", "setRemovalTimeoutInSeconds");
        dispatchTable.put("victim-selection-policy", "setVictimSelectionPolicy");
        return dispatchTable;
    }

    public Node writeDescriptor(Node parent, String nodeName, BeanCacheDescriptor descriptor) {
        Node beanCacheNode = super.writeDescriptor(parent, nodeName, descriptor);
        BeanCacheNode.appendTextChild(beanCacheNode, "max-cache-size", descriptor.getMaxCacheSize());
        BeanCacheNode.appendTextChild(beanCacheNode, "resize-quantity", descriptor.getResizeQuantity());
        BeanCacheNode.appendTextChild(beanCacheNode, "is-cache-overflow-allowed", String.valueOf(descriptor.isIsCacheOverflowAllowed()));
        BeanCacheNode.appendTextChild(beanCacheNode, "cache-idle-timeout-in-seconds", descriptor.getCacheIdleTimeoutInSeconds());
        BeanCacheNode.appendTextChild(beanCacheNode, "removal-timeout-in-seconds", descriptor.getRemovalTimeoutInSeconds());
        BeanCacheNode.appendTextChild(beanCacheNode, "victim-selection-policy", descriptor.getVictimSelectionPolicy());
        return beanCacheNode;
    }
}

