/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.misc;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import java.io.UnsupportedEncodingException;

public class Anonymous
implements SaslClient {
    private byte[] trace;
    private boolean completed = false;

    public Anonymous(String string) throws SaslException {
        if (string instanceof String) {
            try {
                this.trace = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("Cannot encode trace info in UTF-8", (Throwable)unsupportedEncodingException);
            }
        } else {
            this.trace = new byte[0];
        }
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("Already completed");
        }
        this.completed = true;
        return this.trace;
    }

    public String getMechanismName() {
        return "ANONYMOUS";
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (this.completed) {
            return null;
        }
        throw new SaslException("Not completed");
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("ANONYMOUS has no supported QOP");
        }
        throw new SaslException("Not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("ANONYMOUS has no supported QOP");
        }
        throw new SaslException("Not completed");
    }
}

