/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.misc;

import com.sun.security.sasl.misc.Anonymous;
import com.sun.security.sasl.misc.CramMD5;
import com.sun.security.sasl.misc.Plain;
import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslClientFactory;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.util.Policy;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ClientFactory
implements SaslClientFactory {
    private static final String[] myMechs = new String[]{"CRAM-MD5", "PLAIN", "ANONYMOUS"};
    private static final int[] mechPolicies = new int[]{17, 16, 1};
    private static final int CRAMMD5 = 0;
    private static final int PLAIN = 1;
    private static final int ANONYMOUS = 2;
    private byte[] bytepw;
    private String authId;

    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(myMechs[0]) && Policy.checkPolicy((int)mechPolicies[0], (Map)map)) {
                this.getUserInfo("CRAM-MD5", string, callbackHandler);
                return new CramMD5(this.authId, this.bytepw);
            }
            if (stringArray[n].equals(myMechs[1]) && Policy.checkPolicy((int)mechPolicies[1], (Map)map)) {
                this.getUserInfo("PLAIN", string, callbackHandler);
                return new Plain(string, this.authId, this.bytepw);
            }
            if (stringArray[n].equals(myMechs[2]) && Policy.checkPolicy((int)mechPolicies[2], (Map)map)) {
                return new Anonymous(string);
            }
            ++n;
        }
        return null;
    }

    public String[] getMechanismNames(Map map) {
        return Policy.filterMechs((String[])myMechs, (int[])mechPolicies, (Map)map);
    }

    private void getUserInfo(String string, String string2, CallbackHandler callbackHandler) throws SaslException {
        try {
            String string3 = String.valueOf(string) + " authentication id: ";
            String string4 = String.valueOf(string) + " password: ";
            NameCallback nameCallback = string2 == null ? new NameCallback(string3) : new NameCallback(string3, string2);
            PasswordCallback passwordCallback = new PasswordCallback(string4, false);
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
            char[] cArray = passwordCallback.getPassword();
            if (cArray != null) {
                this.bytepw = new String(cArray).getBytes("UTF8");
                passwordCallback.clearPassword();
            } else {
                this.bytepw = null;
            }
            this.authId = nameCallback.getName();
        }
        catch (IOException iOException) {
            throw new SaslException("Cannot get password", (Throwable)iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Cannot get userid/password", (Throwable)unsupportedCallbackException);
        }
    }
}

