/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.appserv.management.config.AuditModuleConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;

public class AuditModuleHandlers {
    private static List auditSkipPropsList = new ArrayList();

    public static void getAuditModuleList(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        Map aMap = config.getSecurityServiceConfig().getAuditModuleConfigMap();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        ArrayList result = new ArrayList();
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        for (AuditModuleConfig auditModule : aMap.values()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String name = auditModule.getName();
            oneRow.put("name", name);
            oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, (List)selectedList) : false);
            String classname = auditModule.getClassname();
            oneRow.put("classname", classname == null ? " " : classname);
            String auditOn = AMXUtil.getPropertyValue((PropertiesAccess)auditModule, (String)"auditOn");
            if (GuiUtil.isEmpty((String)auditOn)) {
                oneRow.put("auditOn", "false");
            } else {
                oneRow.put("auditOn", auditOn);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getAuditModuleSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                return;
            }
            Map auditModules = config.getSecurityServiceConfig().getAuditModuleConfigMap();
            AuditModuleConfig module = (AuditModuleConfig)auditModules.get((String)handlerCtx.getInputValue("Name"));
            String classname = module.getClassname();
            handlerCtx.setOutputValue("Classname", (Object)classname);
            Map aMap = AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)module, (List)auditSkipPropsList);
            handlerCtx.setOutputValue("Properties", (Object)aMap);
            Boolean auditOnFlag = false;
            String auditOn = AMXUtil.getPropertyValue((PropertiesAccess)module, (String)"auditOn");
            if (!GuiUtil.isEmpty((String)auditOn)) {
                auditOnFlag = Boolean.valueOf(auditOn);
            }
            handlerCtx.setOutputValue("auditOn", (Object)auditOnFlag);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveAuditModuleSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        Boolean auditOnB = (Boolean)handlerCtx.getInputValue("auditOn");
        boolean auditOn = auditOnB == null ? false : auditOnB;
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map convertedMap = AMXUtil.convertToPropertiesOptionMap((Map)newProps, null);
                convertedMap.put("property.auditOn", "" + auditOn);
                config.getSecurityServiceConfig().createAuditModuleConfig((String)handlerCtx.getInputValue("Name"), (String)handlerCtx.getInputValue("Classname"), convertedMap);
                return;
            }
            Map modules = config.getSecurityServiceConfig().getAuditModuleConfigMap();
            AuditModuleConfig module = (AuditModuleConfig)modules.get((String)handlerCtx.getInputValue("Name"));
            module.setClassname((String)handlerCtx.getInputValue("Classname"));
            AMXUtil.updateProperties((PropertiesAccess)module, (Map)newProps, (List)auditSkipPropsList);
            AMXUtil.setPropertyValue((PropertiesAccess)module, (String)"auditOn", (String)Boolean.toString(auditOn));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    static {
        auditSkipPropsList.add("auditOn");
    }
}

