/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@I18n(value="jdbc.resource.manager")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private static final String DESCRIPTION = "description";
    String jndiName = null;
    String description = null;
    String poolName = null;
    String enabled = Boolean.TRUE.toString();

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        ResourceStatus status;
        String msg;
        this.jndiName = (String)attrList.get("jndi-name");
        this.description = (String)attrList.get(DESCRIPTION);
        this.poolName = (String)attrList.get("pool-name");
        this.enabled = (String)attrList.get("enabled");
        if (this.jndiName == null) {
            String msg2 = localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            ResourceStatus status2 = new ResourceStatus(1, msg2);
            return status2;
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg3 = localStrings.getLocalString("create.jdbc.resource.duplicate", "A JDBC resource named {0} already exists.", new Object[]{this.jndiName});
            ResourceStatus status3 = new ResourceStatus(1, msg3, true);
            return status3;
        }
        if (!this.isConnPoolExists(resources, this.poolName)) {
            msg = localStrings.getLocalString("create.jdbc.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of jdbc connection pools.", new Object[]{this.poolName});
            status = new ResourceStatus(1, msg);
            return status;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcResource newResource = (JdbcResource)ConfigSupport.createChildOf((Object)param, JdbcResource.class);
                    newResource.setJndiName(JDBCResourceManager.this.jndiName);
                    if (JDBCResourceManager.this.description != null) {
                        newResource.setDescription(JDBCResourceManager.this.description);
                    }
                    newResource.setPoolName(JDBCResourceManager.this.poolName);
                    newResource.setEnabled(JDBCResourceManager.this.enabled);
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)ConfigSupport.createChildOf((Object)newResource, Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled, this.jndiName);
            }
        }
        catch (TransactionFailure tfe) {
            String msg4 = localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName});
            ResourceStatus status4 = new ResourceStatus(1, msg4);
            status4.setException((Throwable)tfe);
            return status4;
        }
        msg = localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        status = new ResourceStatus(0, msg);
        return status;
    }

    public ResourceStatus delete(Resources resources, final JdbcResource[] jdbcResources, final String jndiName, Server targetServer) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            ResourceStatus status = new ResourceStatus(1, msg);
            return status;
        }
        if (!this.isResourceExists(resources, jndiName)) {
            String msg = localStrings.getLocalString("delete.jdbc.resource.notfound", "A JDBC resource named {0} does not exist.", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            return status;
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcResource resource : jdbcResources) {
                        if (!resource.getJndiName().equals(jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
                ResourceStatus status = new ResourceStatus(1, msg);
                return status;
            }
            targetServer.deleteResourceRef(jndiName);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbc.resource.deleteSuccess", "JDBC resource {0} deleted successfully", new Object[]{jndiName});
        ResourceStatus status = new ResourceStatus(0, msg);
        return status;
    }

    public ArrayList list(JdbcResource[] jdbcResources) {
        ArrayList<String> list = new ArrayList<String>();
        for (JdbcResource r : jdbcResources) {
            list.add(r.getJndiName());
        }
        return list;
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnPoolExists(Resources resources, String poolName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcConnectionPool) || !((JdbcConnectionPool)resource).getName().equals(poolName)) continue;
            return true;
        }
        return false;
    }
}

