/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.UDPConnectorHandler;
import com.sun.grizzly.async.UDPAsyncQueueReader;
import com.sun.grizzly.async.UDPAsyncQueueWriter;
import com.sun.grizzly.util.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyOP;
import com.sun.grizzly.util.State;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Callable;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPSelectorHandler
extends TCPSelectorHandler {
    private static final String NOT_SUPPORTED = "Not supported by this SelectorHandler";
    protected DatagramSocket datagramSocket;
    protected DatagramChannel datagramChannel;

    public UDPSelectorHandler() {
        this(Role.CLIENT_SERVER);
    }

    public UDPSelectorHandler(boolean isClient) {
        this(UDPSelectorHandler.boolean2Role(isClient));
    }

    public UDPSelectorHandler(Role role) {
        super(role);
    }

    @Override
    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        UDPSelectorHandler copyHandler = (UDPSelectorHandler)copy;
        copyHandler.datagramSocket = this.datagramSocket;
        copyHandler.datagramChannel = this.datagramChannel;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        this.initOpRegistriesIfRequired();
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new UDPAsyncQueueReader(this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new UDPAsyncQueueWriter(this);
        }
        if (this.selector == null) {
            try {
                this.isShutDown.set(false);
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
                this.datagramChannel = DatagramChannel.open();
                this.selector = Selector.open();
                if (this.role != Role.CLIENT) {
                    this.datagramSocket = this.datagramChannel.socket();
                    this.datagramSocket.setReuseAddress(this.reuseAddress);
                    if (this.inet == null) {
                        this.datagramSocket.bind(new InetSocketAddress(this.port));
                    } else {
                        this.datagramSocket.bind(new InetSocketAddress(this.inet, this.port));
                    }
                    this.datagramChannel.configureBlocking(false);
                    this.datagramChannel.register(this.selector, 1);
                    this.datagramSocket.setSoTimeout(this.serverTimeout);
                }
                ctx.getController().notifyReady();
            }
            catch (SocketException ex) {
                throw new BindException(ex.getMessage() + ": " + this.port);
            }
        } else {
            this.processPendingOperations(ctx);
        }
    }

    @Override
    protected void onConnectOp(Context ctx, SelectionKeyOP.ConnectSelectionKeyOP selectionKeyOp) throws IOException {
        SocketAddress remoteAddress = selectionKeyOp.getRemoteAddress();
        SocketAddress localAddress = selectionKeyOp.getLocalAddress();
        CallbackHandler callbackHandler = selectionKeyOp.getCallbackHandler();
        DatagramChannel datagramChannel = DatagramChannel.open();
        datagramChannel.socket().setReuseAddress(this.reuseAddress);
        if (localAddress != null) {
            datagramChannel.socket().bind(localAddress);
        }
        datagramChannel.configureBlocking(false);
        datagramChannel.connect(remoteAddress);
        SelectionKey key = datagramChannel.register(this.selector, 5);
        key.attach(CallbackHandlerSelectionKeyAttachment.create(key, callbackHandler));
        this.onConnectInterest(key, ctx);
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.getAndSet(true)) {
            return;
        }
        this.stateHolder.setState(State.STOPPED);
        try {
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.close();
            this.asyncQueueReader = null;
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.close();
            this.asyncQueueWriter = null;
        }
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        return false;
    }

    @Override
    public Class<? extends SelectionKeyHandler> getPreferredSelectionKeyHandler() {
        return BaseSelectionKeyHandler.class;
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }

    @Override
    public int getPortLowLevel() {
        if (this.datagramSocket != null) {
            return this.datagramSocket.getLocalPort();
        }
        return -1;
    }

    @Override
    public int getSsBackLog() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSsBackLog(int ssBackLog) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public boolean isTcpNoDelay() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getLinger() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setLinger(int linger) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getSocketTimeout() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void closeChannel(SelectableChannel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.onClose(channel);
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.onClose(channel);
        }
    }

    @Override
    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new UDPConnectorHandler();
            }
        };
    }
}

