/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.JTATransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements JpaEntityManager {
    protected TransactionWrapperImpl transaction = null;
    protected boolean isOpen = true;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected ServerSession serverSession;
    protected EntityManagerFactoryImpl factory;
    protected boolean extended;
    protected boolean propagatePersistenceContext;
    protected boolean beginEarlyTransaction = false;
    protected Map properties;
    protected FlushModeType flushMode;
    protected ReferenceMode referenceMode;
    protected ConnectionPolicy connectionPolicy;

    public EntityManagerImpl(String sessionName, boolean propagatePersistenceContext, boolean extended) {
        this((ServerSession)SessionManager.getManager().getSession(sessionName), null, propagatePersistenceContext, extended);
        this.flushMode = FlushModeType.AUTO;
    }

    public EntityManagerImpl(ServerSession serverSession, boolean propagatePersistenceContext, boolean extended) {
        this(serverSession, null, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, Map properties, boolean propagatePersistenceContext, boolean extended) {
        this.serverSession = serverSession;
        this.detectTransactionWrapper();
        this.extended = true;
        this.propagatePersistenceContext = false;
        if (properties != null) {
            this.properties = new HashMap(properties);
        }
        this.processProperties();
        this.flushMode = FlushModeType.AUTO;
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Map properties, boolean propagatePersistenceContext, boolean extended) {
        this.factory = factory;
        this.serverSession = factory.getServerSession();
        this.detectTransactionWrapper();
        this.extended = true;
        this.propagatePersistenceContext = false;
        if (properties != null) {
            this.properties = new HashMap(properties);
        }
        this.processProperties();
        this.flushMode = FlushModeType.AUTO;
    }

    public void clear() {
        try {
            this.verifyOpen();
            if (this.isExtended()) {
                if (this.extendedPersistenceContext != null) {
                    if (this.checkForTransaction(false) == null) {
                        this.extendedPersistenceContext.clearForClose(true);
                        this.extendedPersistenceContext = null;
                    } else {
                        this.extendedPersistenceContext.clear(true);
                    }
                }
            } else {
                this.transaction.clear();
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void removeExtendedPersistenceContext() {
        this.extendedPersistenceContext = null;
    }

    public void persist(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            try {
                this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).registerNewObjectForPersist(entity, new IdentityHashMap());
            }
            catch (RuntimeException e) {
                if (ValidationException.class.isAssignableFrom(e.getClass())) {
                    throw new EntityExistsException(e.getLocalizedMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T merge(T entity) {
        try {
            this.verifyOpen();
            return (T)this.mergeInternal(entity);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object mergeInternal(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
        }
        Object merged = null;
        RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
        try {
            merged = context.mergeCloneWithReferences(entity, 4, true);
        }
        catch (org.eclipse.persistence.exceptions.OptimisticLockException ole) {
            throw new OptimisticLockException((Throwable)ole);
        }
        return merged;
    }

    public void remove(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).performRemove(entity, new IdentityHashMap());
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            Session session = this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptor(entityClass);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{entityClass}));
            }
            return (T)this.findInternal(descriptor, session, primaryKey);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object find(String entityName, Object primaryKey) {
        try {
            this.verifyOpen();
            Session session = this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_entitybean_name", (Object[])new Object[]{entityName}));
            }
            return this.findInternal(descriptor, session, primaryKey);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object findInternal(ClassDescriptor descriptor, Session session, Object primaryKey) {
        List primaryKeyValues;
        if (primaryKey == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"null_pk"));
        }
        if (primaryKey instanceof List) {
            primaryKeyValues = (List)primaryKey;
        } else {
            if (descriptor.getCMPPolicy().getPKClass() != null && !descriptor.getCMPPolicy().getPKClass().isAssignableFrom(primaryKey.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{descriptor.getCMPPolicy().getPKClass(), primaryKey.getClass()}));
            }
            primaryKeyValues = descriptor.getCMPPolicy().createPkVectorFromKey(primaryKey, (AbstractSession)session);
        }
        ReadObjectQuery query = new ReadObjectQuery(descriptor.getJavaClass());
        query.setSelectionKey(primaryKeyValues);
        query.conformResultsInUnitOfWork();
        query.setIsExecutionClone(true);
        return session.executeQuery((DatabaseQuery)query);
    }

    public void flush() {
        try {
            this.verifyOpen();
            try {
                this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
            }
            catch (RuntimeException e) {
                if (EclipseLinkException.class.isAssignableFrom(e.getClass())) {
                    throw new PersistenceException((Throwable)e);
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    public void refresh(Object entity) {
        try {
            this.verifyOpen();
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
            if (!this.contains(entity, (UnitOfWork)uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"cant_refresh_not_managed_object", (Object[])new Object[]{entity}));
            }
            ReadObjectQuery query = new ReadObjectQuery();
            query.setSelectionObject(entity);
            query.refreshIdentityMapResult();
            query.cascadeByMapping();
            query.setLockMode((short)0);
            query.setIsExecutionClone(true);
            Object refreshedEntity = null;
            refreshedEntity = uow.executeQuery((DatabaseQuery)query);
            if (refreshedEntity == null) {
                throw new EntityNotFoundException(ExceptionLocalization.buildMessage((String)"entity_no_longer_exists_in_db", (Object[])new Object[]{entity}));
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public boolean contains(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.getServerSession().getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"not_an_entity", (Object[])new Object[]{entity}));
            }
            if (!this.hasActivePersistenceContext()) {
                return false;
            }
            return this.contains(entity, (UnitOfWork)this.getActivePersistenceContext(this.checkForTransaction(false)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected boolean contains(Object entity, UnitOfWork uow) {
        return ((UnitOfWorkImpl)uow).isObjectRegistered(entity) && !((UnitOfWorkImpl)uow).isObjectDeleted(entity);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass) {
        return this.createDescriptorNamedQuery(queryName, descriptorClass, null);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass, Vector argumentTypes) {
        try {
            DatabaseQuery query;
            this.verifyOpen();
            ClassDescriptor descriptor = this.getServerSession().getDescriptor(descriptorClass);
            if (descriptor != null && (query = descriptor.getQueryManager().getLocalQueryByArgumentTypes(queryName, argumentTypes)) != null) {
                return new EJBQueryImpl(query, this);
            }
            return null;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNamedQuery(String name) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(name, this, true);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(sqlString, false), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createNativeQueryInternal(sqlString, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            this.verifyOpen();
            ResultSetMappingQuery query = new ResultSetMappingQuery();
            query.setSQLResultSetMappingName(resultSetMapping);
            query.setSQLString(sqlString);
            query.setIsUserDefined(true);
            return new EJBQueryImpl((DatabaseQuery)query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Session getActiveSession() {
        Object txn = this.checkForTransaction(false);
        if (txn == null && !this.isExtended()) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork(this.referenceMode);
        }
        return this.getActivePersistenceContext(txn);
    }

    public Object getDelegate() {
        try {
            this.verifyOpen();
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public FlushModeType getFlushMode() {
        try {
            this.verifyOpen();
            return this.flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    @Override
    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork(this.referenceMode);
        }
        return null;
    }

    public EntityTransaction getTransaction() {
        try {
            return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getProperty(String name) {
        Object propertyValue = null;
        if (name == null) {
            return null;
        }
        if (this.properties != null) {
            propertyValue = this.properties.get(name);
        }
        if (propertyValue == null) {
            propertyValue = this.factory.getServerSession().getProperty(name);
        }
        return propertyValue;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            UnitOfWork session = (UnitOfWork)this.getActiveSession();
            Object reference = session.getReference(entityClass, primaryKey);
            if (reference == null) {
                Object[] args = new Object[]{primaryKey};
                String message = ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_reference", (Object[])args);
                throw new EntityNotFoundException(message);
            }
            return (T)reference;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String sqlString, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return query;
    }

    @Override
    public Query createQuery(Expression expression, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createQueryInternal(expression, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(String jpqlString) {
        try {
            EJBQueryImpl ejbqImpl;
            this.verifyOpen();
            try {
                ejbqImpl = new EJBQueryImpl(jpqlString, this);
            }
            catch (JPQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"wrap_ejbql_exception"), exception);
            }
            return ejbqImpl;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSelectionCriteria(expression);
        return query;
    }

    public void close() {
        try {
            this.verifyOpen();
            this.isOpen = false;
            this.factory = null;
            this.serverSession = null;
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null && !this.extendedPersistenceContext.isSynchronized()) {
                    this.extendedPersistenceContext.release();
                    this.extendedPersistenceContext.getParent().release();
                } else {
                    this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
                }
                this.extendedPersistenceContext = null;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    public boolean isOpen() {
        return this.isOpen && this.factory.isOpen();
    }

    public void lock(Object entity, LockModeType lockMode) {
        try {
            this.verifyOpen();
            RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
            ClassDescriptor descriptor = context.getDescriptor(entity);
            OptimisticLockingPolicy lockingPolicy = descriptor.getOptimisticLockingPolicy();
            if (lockingPolicy == null || !(lockingPolicy instanceof VersionLockingPolicy)) {
                throw new PersistenceException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-lock_called_without_version_locking-index", null));
            }
            context.forceUpdateToVersionField(entity, lockMode == LockModeType.WRITE);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void verifyOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object txn) {
        if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
            this.extendedPersistenceContext = new RepeatableWriteUnitOfWork((AbstractSession)this.serverSession.acquireClientSession(this.connectionPolicy, this.properties), this.referenceMode);
            this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(true);
            this.extendedPersistenceContext.setShouldCascadeCloneToJoinedRelationship(true);
            if (txn != null) {
                this.transaction.registerUnitOfWorkWithTxn((UnitOfWorkImpl)this.extendedPersistenceContext);
            }
        }
        if (this.beginEarlyTransaction && txn != null && !this.extendedPersistenceContext.isInTransaction()) {
            this.extendedPersistenceContext.beginEarlyTransaction();
        }
        return this.extendedPersistenceContext;
    }

    public void setProperties(Map properties) {
        if (this.hasActivePersistenceContext()) {
            this.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_properties_while_context_is_active");
        }
        this.properties = properties;
        this.processProperties();
    }

    private boolean hasActivePersistenceContext() {
        return !this.isExtended() || this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected Object checkForTransaction(boolean validateExistence) {
        return this.transaction.checkForTransaction(validateExistence);
    }

    public boolean shouldFlushBeforeQuery() {
        Object foundTransaction = this.checkForTransaction(false);
        return foundTransaction != null && this.transaction.shouldFlushBeforeQuery((UnitOfWorkImpl)this.getActivePersistenceContext(foundTransaction));
    }

    public boolean shouldPropagatePersistenceContext() {
        return this.propagatePersistenceContext;
    }

    public boolean shouldBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void joinTransaction() {
        try {
            this.verifyOpen();
            this.transaction.registerUnitOfWorkWithTxn((UnitOfWorkImpl)this.getActivePersistenceContext(this.checkForTransaction(true)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setRollbackOnly() {
        this.transaction.setRollbackOnlyInternal();
    }

    private void processProperties() {
        String referenceMode;
        String beginEarlyTransactionProperty = this.getPropertiesHandlerProperty("eclipselink.transaction.join-existing");
        if (beginEarlyTransactionProperty != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
        }
        if ((referenceMode = this.getPropertiesHandlerProperty("eclipselink.persistence-context.reference-mode")) != null) {
            this.referenceMode = ReferenceMode.valueOf((String)referenceMode);
        }
        this.connectionPolicy = this.processConnectionPolicyProperties();
    }

    protected String getPropertiesHandlerProperty(String name) {
        return PropertiesHandler.getSessionPropertyValue((String)name, (Map)this.properties, (AbstractSession)this.getServerSession());
    }

    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }

    public void setFlushMode(FlushModeType flushMode) {
        try {
            this.verifyOpen();
            this.flushMode = flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
    }

    protected ConnectionPolicy processConnectionPolicyProperties() {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        ConnectionPolicy policy = this.serverSession.getDefaultConnectionPolicy();
        if (this.properties == null || this.properties.isEmpty()) {
            return policy;
        }
        ConnectionPolicy policyFromProperties = (ConnectionPolicy)this.properties.get("eclipselink.jdbc.connection-policy");
        if (policyFromProperties != null) {
            policy = policyFromProperties;
        }
        ConnectionPolicy newPolicy = null;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", this.properties, (AbstractSession)this.serverSession, false);
        if (isLazyString != null) {
            boolean isLazy = Boolean.parseBoolean(isLazyString);
            if (policy.isLazy() != isLazy) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                newPolicy.setIsLazy(isLazy);
            }
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(this.properties, (AbstractSession)this.serverSession, false)) != null && !exclusiveMode.equals((Object)policy.getExclusiveMode())) {
            if (newPolicy == null) {
                newPolicy = (ConnectionPolicy)policy.clone();
            }
            newPolicy.setExclusiveMode(exclusiveMode);
        }
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.user", this.properties, (AbstractSession)this.serverSession, false);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.password", this.properties, (AbstractSession)this.serverSession, false);
        String driver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.driver", this.properties, (AbstractSession)this.serverSession, false);
        String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.url", this.properties, (AbstractSession)this.serverSession, false);
        Object jtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.jtaDataSource", this.properties, (AbstractSession)this.serverSession, false);
        DataSource jtaDataSource = null;
        String jtaDataSourceName = null;
        if (jtaDataSourceObj != null) {
            if (jtaDataSourceObj instanceof DataSource) {
                jtaDataSource = (DataSource)jtaDataSourceObj;
            } else if (jtaDataSourceObj instanceof String) {
                jtaDataSourceName = (String)jtaDataSourceObj;
            }
        }
        Object nonjtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.nonJtaDataSource", this.properties, (AbstractSession)this.serverSession, false);
        DataSource nonjtaDataSource = null;
        String nonjtaDataSourceName = null;
        if (nonjtaDataSourceObj != null) {
            if (nonjtaDataSourceObj instanceof DataSource) {
                nonjtaDataSource = (DataSource)nonjtaDataSourceObj;
            } else if (nonjtaDataSourceObj instanceof String) {
                nonjtaDataSourceName = (String)nonjtaDataSourceObj;
            }
        }
        if (user != null || password != null || driver != null || connectionString != null || jtaDataSourceObj != null || nonjtaDataSourceObj != null) {
            Boolean isNewUserRequired;
            boolean isJNDIConnectorRequired;
            boolean isDefaultConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(driver) || EntityManagerImpl.isPropertyToBeAdded(connectionString);
            boolean bl = isJNDIConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName) || EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName);
            if (isDefaultConnectorRequired && isJNDIConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_jndi_connector", (Object[])new Object[0]));
            }
            DatasourceLogin login = (DatasourceLogin)policy.getLogin();
            if (login == null) {
                login = policy.getPoolName() != null ? (DatasourceLogin)this.serverSession.getConnectionPool(policy.getPoolName()).getLogin() : (DatasourceLogin)this.serverSession.getDatasourceLogin();
            }
            if (login.shouldUseExternalTransactionController() && isDefaultConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"entity_manager_properties_conflict_default_connector_vs_external_transaction_controller", (Object[])new Object[0]));
            }
            DataSource dataSource = null;
            String dataSourceName = null;
            if (isJNDIConnectorRequired) {
                if (login.shouldUseExternalTransactionController()) {
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        dataSource = jtaDataSource;
                        dataSourceName = jtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_nonjta_data_source");
                    }
                } else {
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        dataSource = nonjtaDataSource;
                        dataSourceName = nonjtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_jta_data_source");
                    }
                }
            }
            Boolean isNewPasswordRequired = (isNewUserRequired = this.isPropertyValueToBeUpdated(login.getUserName(), user)) != null && isNewUserRequired == false ? Boolean.FALSE : this.isPropertyValueToBeUpdated(login.getPassword(), password);
            DefaultConnector oldDefaultConnector = null;
            if (login.getConnector() instanceof DefaultConnector) {
                oldDefaultConnector = (DefaultConnector)login.getConnector();
            }
            boolean isNewDefaultConnectorRequired = oldDefaultConnector == null && isDefaultConnectorRequired;
            JNDIConnector oldJNDIConnector = null;
            if (login.getConnector() instanceof JNDIConnector) {
                oldJNDIConnector = (JNDIConnector)login.getConnector();
            }
            boolean isNewJNDIConnectorRequired = oldJNDIConnector == null && isJNDIConnectorRequired;
            Boolean isNewDriverRequired = null;
            Boolean isNewConnectionStringRequired = null;
            if (isNewDefaultConnectorRequired) {
                isNewDriverRequired = this.isPropertyValueToBeUpdated(null, driver);
                isNewConnectionStringRequired = this.isPropertyValueToBeUpdated(null, connectionString);
            } else if (oldDefaultConnector != null) {
                isNewDriverRequired = this.isPropertyValueToBeUpdated(oldDefaultConnector.getDriverClassName(), driver);
                isNewConnectionStringRequired = this.isPropertyValueToBeUpdated(oldDefaultConnector.getConnectionString(), connectionString);
            }
            Boolean isNewDataSourceRequired = null;
            if (isNewJNDIConnectorRequired) {
                isNewDataSourceRequired = Boolean.TRUE;
            } else if (oldJNDIConnector != null) {
                if (dataSource != null) {
                    if (!dataSource.equals(oldJNDIConnector.getDataSource())) {
                        isNewDataSourceRequired = Boolean.TRUE;
                    }
                } else if (dataSourceName != null && !dataSourceName.equals(oldJNDIConnector.getName())) {
                    isNewDataSourceRequired = Boolean.TRUE;
                }
            }
            if (isNewUserRequired != null || isNewPasswordRequired != null || isNewDriverRequired != null || isNewConnectionStringRequired != null || isNewDataSourceRequired.booleanValue()) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                DatasourceLogin newLogin = (DatasourceLogin)newPolicy.getLogin();
                if (newPolicy.getLogin() == null || newPolicy.getLogin() == policy.getLogin()) {
                    newLogin = (DatasourceLogin)login.clone();
                    newPolicy.setLogin((Login)newLogin);
                }
                newPolicy.setPoolName(null);
                if (isNewUserRequired != null) {
                    if (isNewUserRequired.booleanValue()) {
                        newLogin.setProperty("user", (Object)user);
                    } else {
                        newLogin.getProperties().remove("user");
                    }
                }
                if (isNewPasswordRequired != null) {
                    if (isNewPasswordRequired.booleanValue()) {
                        newLogin.setProperty("password", (Object)password);
                    } else {
                        newLogin.getProperties().remove("password");
                    }
                }
                if (isNewDefaultConnectorRequired) {
                    newLogin.setConnector((Connector)new DefaultConnector());
                    newLogin.setUsesExternalConnectionPooling(false);
                } else if (isNewJNDIConnectorRequired) {
                    newLogin.setConnector((Connector)new JNDIConnector());
                    newLogin.setUsesExternalConnectionPooling(true);
                }
                if (isDefaultConnectorRequired) {
                    DefaultConnector defaultConnector = (DefaultConnector)newLogin.getConnector();
                    if (isNewDriverRequired != null) {
                        if (isNewDriverRequired.booleanValue()) {
                            defaultConnector.setDriverClassName(driver);
                        } else {
                            defaultConnector.setDriverClassName(null);
                        }
                    }
                    if (isNewConnectionStringRequired != null) {
                        if (isNewConnectionStringRequired.booleanValue()) {
                            defaultConnector.setDatabaseURL(connectionString);
                        } else {
                            defaultConnector.setDatabaseURL(null);
                        }
                    }
                } else if (isNewDataSourceRequired != null) {
                    JNDIConnector jndiConnector = (JNDIConnector)newLogin.getConnector();
                    if (isNewDataSourceRequired.booleanValue()) {
                        if (dataSource != null) {
                            jndiConnector.setDataSource(dataSource);
                        } else {
                            jndiConnector.setName(dataSourceName);
                        }
                    }
                }
            }
        }
        if (newPolicy != null) {
            return newPolicy;
        }
        return policy;
    }

    protected static boolean isPropertyToBeAdded(String value) {
        return value != null && value.length() > 0;
    }

    protected static boolean isPropertyToBeAdded(DataSource ds, String dsName) {
        return ds != null || dsName != null && dsName.length() > 0;
    }

    protected static boolean isPropertyToBeRemoved(String value) {
        return value != null && value.length() == 0;
    }

    protected Boolean isPropertyValueToBeUpdated(String oldValue, String newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue.length() > 0) {
            if (oldValue != null) {
                if (newValue.equals(oldValue)) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        if (oldValue != null) {
            return Boolean.FALSE;
        }
        return null;
    }
}

