/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GFEmbeddedLauncher
extends GFLauncher {
    private File gfeJar;
    private File installDir;
    private File javaExe;
    private File domainDir;
    private File domainXml;
    private static final String GFE_JAR = "GFE_JAR";
    private static final String INSTALL_HOME = "S1AS_HOME";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String DOMAIN_DIR = "GFE_DOMAIN";
    private static final String GENERAL_MESSAGE = "You must setup four different environmental variables to run embedded with asadmin.  They are\nGFE_JAR - path to the embedded jar\nS1AS_HOME - path to installation directory.  This can be empty or not exist yet.\nJAVA_HOME - path to a JDK installation.  JRE installation is generally not good enough\nGFE_DOMAIN - path to the domain dir's config dir.  I.e. this is where the domain.xml will be written.\nGFE_DEBUG_PORT - optional debugging port.  It will start suspended.\n";

    public GFEmbeddedLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    void internalLaunch() throws GFLauncherException {
        try {
            this.launchInstance();
        }
        catch (Exception ex) {
            throw new GFLauncherException(ex);
        }
    }

    @Override
    List<File> getMainClasspath() throws GFLauncherException {
        File f;
        ArrayList<File> list = new ArrayList<File>(1);
        String gfeJar = System.getenv(GFE_JAR);
        if (GFLauncherUtils.ok((String)gfeJar) && (f = new File(gfeJar)).isFile()) {
            list.add(f);
            return list;
        }
        throw new GFLauncherException("no_gfe_jar");
    }

    @Override
    String getMainClass() throws GFLauncherException {
        return "org.glassfish.embed.EmbeddedMain";
    }

    @Override
    public synchronized void setup() throws GFLauncherException, MiniXmlParserException {
        try {
            this.setupFromEnv();
        }
        catch (GFLauncherException gfle) {
            String msg = "";
            throw new GFLauncherException(GENERAL_MESSAGE + gfle.getMessage());
        }
        this.setClasspath(this.gfeJar.getPath());
        this.setCommandLine();
        this.logCommandLine();
    }

    @Override
    void setCommandLine() throws GFLauncherException {
        List<String> cmdLine = this.getCommandLine();
        cmdLine.clear();
        cmdLine.add(this.javaExe.getPath());
        cmdLine.add("-cp");
        cmdLine.add(this.getClasspath());
        this.addDebug(cmdLine);
        cmdLine.add(this.getMainClass());
        cmdLine.add("--port");
        cmdLine.add("8080");
        cmdLine.add("--xml");
        cmdLine.add(this.domainXml.getPath());
        cmdLine.add("--dir");
        cmdLine.add(this.installDir.getPath());
        cmdLine.add("--autodelete");
        cmdLine.add("false");
    }

    private void addDebug(List<String> cmdLine) {
        String s = System.getenv("GFE_DEBUG_PORT");
        if (this.ok(s)) {
            cmdLine.add("-Xdebug");
            cmdLine.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + s);
        }
    }

    private void setupFromEnv() throws GFLauncherException {
        this.setupEmbeddedJar();
        this.setupInstallationDir();
        this.setupJDK();
        this.setupDomainDir();
    }

    private void setupDomainDir() throws GFLauncherException {
        String err = "You must set the environmental variable GFE_DOMAIN to point at an existing GlassFish domain or at an empty directory or at a location where an empty directory can be created.";
        String domainDirName = System.getenv(DOMAIN_DIR);
        if (!this.ok(domainDirName)) {
            throw new GFLauncherException(err);
        }
        this.domainDir = new File(domainDirName);
        if (!this.domainDir.isDirectory()) {
            this.domainDir.mkdirs();
        }
        if (!this.domainDir.isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.domainDir = SmartFile.sanitize((File)this.domainDir);
        this.domainXml = SmartFile.sanitize((File)new File(this.domainDir, "config/domain.xml"));
    }

    private void setupJDK() throws GFLauncherException {
        String err = "You must set the environmental variable JAVA_HOME to point at a valid JDK.  <jdk>/bin/javac[.exe] must exist.";
        String jdkDirName = System.getenv(JAVA_HOME);
        if (!this.ok(jdkDirName)) {
            throw new GFLauncherException(err);
        }
        File jdkDir = new File(jdkDirName);
        if (!jdkDir.isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = File.separatorChar == '\\' ? new File(jdkDir, "bin/java.exe") : new File(jdkDir, "bin/java");
        if (!this.javaExe.isFile()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = SmartFile.sanitize((File)this.javaExe);
    }

    private void setupInstallationDir() throws GFLauncherException {
        String err = "You must set the environmental variable S1AS_HOME to point at a GlassFish installation or at an empty directory or at a location where an empty directory can be created.";
        String installDirName = System.getenv(INSTALL_HOME);
        if (!this.ok(installDirName)) {
            throw new GFLauncherException(err);
        }
        this.installDir = new File(installDirName);
        if (!this.installDir.isDirectory()) {
            this.installDir.mkdirs();
        }
        if (!this.installDir.isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.installDir = SmartFile.sanitize((File)this.installDir);
    }

    private void setupEmbeddedJar() throws GFLauncherException {
        String err = "You must set the environmental variable GFE_JAR to point at the Embedded jarfile.";
        String gfeJarName = System.getenv(GFE_JAR);
        if (!this.ok(gfeJarName)) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = new File(gfeJarName);
        if (!this.gfeJar.isFile() || this.gfeJar.length() < 1000000L) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = SmartFile.sanitize((File)this.gfeJar);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

