/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.ArgumentManager;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFLauncherInfo {
    private GFLauncherFactory.ServerType type;
    private boolean verbose = false;
    private boolean debug = false;
    File installDir;
    private File domainParentDir;
    private File domainRootDir;
    private File instanceRootDir;
    private File configDir;
    private File configFile;
    private String domainName;
    private String instanceName;
    private boolean valid = false;
    private Map<String, String> argsMap;
    private ArrayList<String> argsRaw = new ArrayList();
    private Set<Integer> adminPorts;
    private static final String DEFAULT_DOMAIN_PARENT_DIR = "domains";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_FILENAME = "domain.xml";

    public void addArgs(String ... args) {
        for (String s : args) {
            this.argsRaw.add(s);
        }
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainParentDir(String domainParentName) {
        this.domainParentDir = new File(domainParentName);
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setDomainRootDir(File f) {
        this.domainRootDir = f;
    }

    public boolean isDomain() {
        return this.type == GFLauncherFactory.ServerType.domain;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getDomainRootDir() {
        return this.domainRootDir;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Set<Integer> getAdminPorts() {
        return this.adminPorts;
    }

    public GFLauncherFactory.ServerType getType() {
        return this.type;
    }

    public File getConfigDir() {
        return SmartFile.sanitize((File)this.configDir);
    }

    public File getInstanceRootDir() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
        }
        if (this.instanceRootDir != null) {
            return this.instanceRootDir;
        }
        if (this.isDomain()) {
            return this.domainRootDir;
        }
        throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
    }

    public String[] getArgsAsStringArray() throws GFLauncherException {
        List<String> list = this.getArgsAsList();
        String[] ss = new String[list.size()];
        return list.toArray(ss);
    }

    public List<String> getArgsAsList() throws GFLauncherException {
        Map<String, String> map = this.getArgs();
        Set<String> keys = map.keySet();
        ArrayList<String> argList = new ArrayList<String>();
        boolean i = false;
        for (String key : keys) {
            argList.add(key);
            argList.add(map.get(key));
        }
        return argList;
    }

    public Map<String, String> getArgs() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getArgs() on an invalid GFLauncherInfo object.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-domaindir", SmartFile.sanitize((String)this.domainRootDir.getPath()));
        map.put("-verbose", Boolean.toString(this.verbose));
        map.put("-debug", Boolean.toString(this.debug));
        map.put("-domainname", this.domainName);
        map.put("-instancename", this.instanceName);
        return map;
    }

    GFLauncherInfo(GFLauncherFactory.ServerType type) {
        this.type = type;
    }

    void setAdminPorts(Set<Integer> adminPorts) {
        this.adminPorts = adminPorts;
    }

    void setup() throws GFLauncherException {
        this.setupFromArgs();
        this.finalSetup();
    }

    void setInstallDir(File f) {
        this.installDir = f;
    }

    File getInstallDir() {
        return this.installDir;
    }

    private void setupFromArgs() {
        this.argsMap = ArgumentManager.argsToMap(this.argsRaw);
        File f = null;
        String s = null;
        Boolean b = null;
        f = this.getFile("domaindir");
        if (f != null) {
            this.domainParentDir = f;
        }
        if ((f = this.getFile("instanceRootDir")) != null) {
            this.instanceRootDir = f;
        }
        if ((f = this.getFile("domainroot")) != null) {
            this.domainRootDir = f;
        }
        if ((s = this.getString("domain")) != null) {
            this.domainName = s;
        }
        if (!GFLauncherUtils.ok((String)this.domainName) && (s = this.getString("default")) != null) {
            this.domainName = s;
        }
        if ((s = this.getString("instancename")) != null) {
            this.instanceName = s;
        }
        if ((b = this.getBoolean("debug")) != null) {
            this.debug = b;
        }
        if ((b = this.getBoolean("verbose")) != null) {
            this.verbose = b;
        }
    }

    private void finalSetup() throws GFLauncherException {
        if (this.installDir == null) {
            this.installDir = GFLauncherUtils.getInstallDir();
        }
        if (!GFLauncherUtils.safeIsDirectory((File)this.installDir)) {
            throw new GFLauncherException("noInstallDir", this.installDir);
        }
        if (this.domainParentDir != null && !GFLauncherUtils.safeIsDirectory((File)this.domainParentDir)) {
            throw new GFLauncherException("noDomainParentDir", this.domainParentDir);
        }
        this.setupDomainRootDir();
        if (!GFLauncherUtils.safeIsDirectory((File)this.domainRootDir)) {
            throw new GFLauncherException("noDomainRootDir", this.domainRootDir);
        }
        this.configDir = new File(this.domainRootDir, CONFIG_DIR);
        if (!GFLauncherUtils.safeIsDirectory((File)this.configDir)) {
            throw new GFLauncherException("noConfigDir", this.configDir);
        }
        this.configFile = new File(this.configDir, CONFIG_FILENAME);
        if (!GFLauncherUtils.safeExists((File)this.configFile)) {
            throw new GFLauncherException("noConfigFile", this.configFile);
        }
        if (this.instanceName == null) {
            this.instanceName = "server";
        }
        this.valid = true;
    }

    private void setupDomainRootDir() throws GFLauncherException {
        if (this.domainRootDir != null) {
            this.domainParentDir = this.domainRootDir.getParentFile();
            this.domainName = this.domainRootDir.getName();
            return;
        }
        if (this.domainParentDir == null) {
            this.domainParentDir = new File(this.installDir, DEFAULT_DOMAIN_PARENT_DIR);
        }
        if (this.domainName == null) {
            this.domainName = this.getTheOneAndOnlyDomain();
        }
        this.domainRootDir = new File(this.domainParentDir, this.domainName);
    }

    private String getTheOneAndOnlyDomain() throws GFLauncherException {
        File[] files = this.domainParentDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return GFLauncherUtils.safeIsDirectory((File)f);
            }
        });
        if (files == null || files.length == 0) {
            throw new GFLauncherException("noDomainDirs", this.domainParentDir);
        }
        if (files.length > 1) {
            throw new GFLauncherException("tooManyDomainDirs", this.domainParentDir);
        }
        return files[0].getName();
    }

    private Boolean getBoolean(String key) {
        String s = this.getValueIgnoreCommandDelimiter(key);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return null;
    }

    private File getFile(String key) {
        String s = this.getString(key);
        if (s == null) {
            return null;
        }
        return new File(s);
    }

    private String getString(String key) {
        return this.getValueIgnoreCommandDelimiter(key);
    }

    private String getValueIgnoreCommandDelimiter(String key) {
        if (this.argsMap.containsKey(key)) {
            return this.argsMap.get(key);
        }
        key = "-" + key;
        if (this.argsMap.containsKey(key)) {
            return this.argsMap.get(key);
        }
        key = "-" + key;
        if (this.argsMap.containsKey(key)) {
            return this.argsMap.get(key);
        }
        return null;
    }
}

