/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.universal.BASE64Decoder;
import com.sun.grizzly.tcp.Request;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.glassfish.internal.api.AdminAuthenticator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class FileBasedAdminAuthenticator
implements AdminAuthenticator {
    private static final String BASIC = "Basic ";
    private static final BASE64Decoder decoder = new BASE64Decoder();
    @Inject
    Logger logger;

    public boolean authenticate(Request request, File fileRealm) throws Exception {
        String authHeader = request.getHeader("Authorization");
        boolean authenticated = false;
        FileRealm f = new FileRealm(fileRealm.getAbsolutePath());
        authenticated = this.authenticateAnonymous(f);
        if (!authenticated && authHeader != null) {
            String base64Coded = authHeader.substring(BASIC.length());
            String decoded = new String(decoder.decodeBuffer(base64Coded));
            String[] userNamePassword = decoded.split(":");
            if (userNamePassword == null || userNamePassword.length == 0) {
                authenticated = this.authenticateAnonymous(f);
            } else {
                String userName = userNamePassword[0];
                String password = userNamePassword.length > 1 ? userNamePassword[1] : "";
                authenticated = f.authenticate(userName, password) != null;
            }
        }
        return authenticated;
    }

    private boolean authenticateAnonymous(FileRealm f) throws Exception {
        Enumeration users = f.getUserNames();
        if (users.hasMoreElements()) {
            String userNameInRealm = (String)users.nextElement();
            if (!users.hasMoreElements() && userNameInRealm.equals("anonymous")) {
                this.logger.finer("Allowed anonymous access");
                return true;
            }
        }
        return false;
    }
}

