/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.Average;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="average")
@Scoped(value=PerLookup.class)
public class AverageImpl
extends AbstractTreeNode
implements Average {
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    public static final long DEFAULT_VALUE;
    public static final long DEFAULT_MIN_BOUND;
    protected static final String NEWLINE;
    AtomicLong min = new AtomicLong(DEFAULT_MIN_BOUND);
    AtomicLong max = new AtomicLong(0L);
    AtomicLong times = new AtomicLong(0L);
    AtomicLong sum = new AtomicLong(0L);
    private long startTime = 0L;
    private AtomicLong lastSampleTime = new AtomicLong(0L);
    private String NAME = "average";
    private String DESCRIPTION = "Average RangeStatistic";
    private String UNIT = Long.class.toString();

    public AverageImpl() {
        this.name = this.NAME;
        this.instance = this;
        this.enabled = true;
        this.startTime = System.currentTimeMillis();
    }

    public void addDataPoint(long value) {
        if (this.min.get() == DEFAULT_MIN_BOUND) {
            this.min.set(value);
        }
        if (value < this.min.get()) {
            this.min.set(value);
        } else if (value > this.max.get()) {
            this.max.set(value);
        }
        this.sum.addAndGet(value);
        this.times.incrementAndGet();
        this.lastSampleTime.set(this.getSampleTime());
    }

    public double getAverage() {
        double count;
        double total = this.sum.doubleValue();
        double avg = total / (count = this.times.doubleValue());
        return Double.isNaN(avg) ? 0.0 : avg;
    }

    public void setReset() {
        this.times.set(0L);
        this.sum.set(0L);
    }

    public long getMin() {
        return this.min.get();
    }

    public long getMax() {
        return this.max.get();
    }

    public String toString() {
        return "Statistic " + this.getClass().getName() + NEWLINE + "Name: " + this.getName() + NEWLINE + "Description: " + this.getDescription() + NEWLINE + "Unit: " + this.getUnit() + NEWLINE + "StartTime: " + this.getStartTime();
    }

    public Object getValue() {
        return this.getAverage();
    }

    public long getSize() {
        return this.times.get();
    }

    public long getHighWaterMark() {
        return this.getMax();
    }

    public long getLowWaterMark() {
        return this.getMin();
    }

    public long getCurrent() {
        double avg = this.getAverage();
        return Long.parseLong(Double.toString(avg));
    }

    public String getUnit() {
        return this.UNIT;
    }

    public String getDescription() {
        return this.DESCRIPTION;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotal() {
        return this.sum.get();
    }

    private long getSampleTime() {
        return System.currentTimeMillis();
    }

    public long getLastSampleTime() {
        return this.lastSampleTime.longValue();
    }

    static {
        DEFAULT_MIN_BOUND = DEFAULT_VALUE = BigInteger.ZERO.longValue();
        NEWLINE = System.getProperty("line.separator");
    }
}

