/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-system-property")
@Scoped(value=PerLookup.class)
@I18n(value="delete.system.property")
public class DeleteSystemProperty
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSystemProperty.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="property_name", primary=true)
    String propName;
    @Inject
    Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (Server server : this.servers) {
                if (!server.getName().equals(this.target) || ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                    public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                        for (SystemProperty prop : param.getSystemProperty()) {
                            if (!prop.getName().equals(DeleteSystemProperty.this.propName)) continue;
                            return param.getSystemProperty().remove(prop);
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)server) != null) continue;
                report.setMessage(localStrings.getLocalString("delete.system.property.doesNotExist", "A system property named {0} does not exist.", new Object[]{this.propName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.system.property.failed", "System property {0} deletion failed", new Object[]{this.propName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.system.property.failed", "System property {0} deletion failed", new Object[]{this.propName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

