/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectStreamFactory;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithoutCL;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.Constants;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebPipeline;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.monitor.impl.PwcServletStatsImpl;
import com.sun.enterprise.web.monitor.impl.PwcWebModuleStatsImpl;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.reconfig.HttpServiceConfigListener;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import com.sun.enterprise.web.stats.ServletStatsImpl;
import com.sun.enterprise.web.stats.WebModuleStatsImpl;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.hk2.component.ConstructorWomb;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.ServerInfo;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.xmlparser.ParserUtils;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.admin.monitor.JspProbeProvider;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.admin.monitor.ServletProbeProvider;
import org.glassfish.web.admin.monitor.SessionProbeProvider;
import org.glassfish.web.admin.monitor.WebModuleProbeProvider;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.web.WebContainer")
public class WebContainer
implements Container,
PostConstruct,
PreDestroy,
EventListener {
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    static final int DEFAULT_REAP_INTERVAL = 60;
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOC_BUILDER_FACTORY_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOC_BUILDER_FACTORY_IMPL = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    private static final WebModuleProbeProvider NO_OP_WEBMODULE_PROBE_PROVIDER = (WebModuleProbeProvider)Proxy.newProxyInstance(WebModuleProbeProvider.class.getClassLoader(), new Class[]{WebModuleProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    private static final ServletProbeProvider NO_OP_SERVLET_PROBE_PROVIDER = (ServletProbeProvider)Proxy.newProxyInstance(ServletProbeProvider.class.getClassLoader(), new Class[]{ServletProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    private static final SessionProbeProvider NO_OP_SESSION_PROBE_PROVIDER = (SessionProbeProvider)Proxy.newProxyInstance(SessionProbeProvider.class.getClassLoader(), new Class[]{SessionProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    private static final JspProbeProvider NO_OP_JSP_PROBE_PROVIDER = (JspProbeProvider)Proxy.newProxyInstance(JspProbeProvider.class.getClassLoader(), new Class[]{JspProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    private static final RequestProbeProvider NO_OP_REQUEST_PROBE_PROVIDER = (RequestProbeProvider)Proxy.newProxyInstance(RequestProbeProvider.class.getClassLoader(), new Class[]{RequestProbeProvider.class}, (InvocationHandler)new NoopInvocationHandler());
    protected static final Logger _logger = LogDomains.getLogger(WebContainer.class, (String)"javax.enterprise.system.container.web");
    protected static WebContainer webContainer;
    protected static boolean useDOLforDeployment;
    @Inject
    Domain domain;
    @Inject
    ServerContext _serverContext;
    @Inject
    ComponentEnvManager componentEnvManager;
    @Inject(optional=true)
    DasConfig dasConfig;
    @Inject
    Events events;
    @Inject
    ClassLoaderHierarchy clh;
    @Inject
    GrizzlyService grizzlyService;
    @Inject
    JavaEEObjectStreamFactory javaEEObjectStreamFactory;
    HashMap<String, Integer> portMap = new HashMap();
    HashMap<String, WebConnector> connectorMap = new HashMap();
    EmbeddedWebContainer _embedded;
    Engine engine;
    String instanceName;
    private WebConnector jkConnector;
    private String _id = null;
    protected boolean globalAccessLoggingEnabled = true;
    protected String globalAccessLogBufferSize = null;
    protected String globalAccessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;
    protected boolean catalinaCachingAllowed = true;
    @Inject
    protected ServerEnvironment instance = null;
    private Server _serverBean = null;
    protected static final ResourceBundle rb;
    protected static MonitoringLevel monitoringLevel;
    protected int _debug = 0;
    private String _modulesWorkRoot = null;
    private String modulesStubRoot = null;
    protected File _modulesRoot = null;
    private String _appsWorkRoot = null;
    private String appsStubRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = 2;
    protected boolean _started = false;
    protected boolean globalSSOEnabled = true;
    protected WebContainerFeatureFactory webContainerFeatureFactory;
    boolean instanceEnableCookies = true;
    private Config cfg;
    private ServerConfigLookup serverConfigLookup;
    @Inject
    protected ProbeProviderFactory probeProviderFactory = null;
    protected JspProbeProvider jspProbeProvider = null;
    protected RequestProbeProvider requestProbeProvider = null;
    protected ServletProbeProvider servletProbeProvider = null;
    protected SessionProbeProvider sessionProbeProvider = null;
    protected WebModuleProbeProvider webModuleProbeProvider = null;
    protected Habitat habitat;
    protected HttpServiceConfigListener configListener = null;
    private boolean isShutdown = false;
    private HealthChecker _healthChecker = null;

    public void postConstruct() {
        this.createProbeProviders();
        this.habitat = this._serverContext.getDefaultHabitat();
        WebContainer.setJspFactory();
        this._modulesWorkRoot = this.instance.getWebModuleCompileJspPath().getAbsolutePath();
        this._appsWorkRoot = this.instance.getApplicationCompileJspPath().getAbsolutePath();
        this._modulesRoot = this.instance.getApplicationRepositoryPath();
        this.setTldScan();
        this.modulesStubRoot = this.instance.getModuleStubPath();
        this.appsStubRoot = this.instance.getApplicationStubPath().getAbsolutePath();
        File root = this._serverContext.getInstallRoot();
        File libRoot = new File(root, "lib");
        File schemas = new File(libRoot, "schemas");
        File dtds = new File(libRoot, "dtds");
        try {
            ParserUtils.setSchemaResourcePrefix(schemas.toURL().toString());
            ParserUtils.setDtdResourcePrefix(dtds.toURL().toString());
            ParserUtils.setEntityResolver((EntityResolver)this.habitat.getComponent(EntityResolver.class, "web"));
        }
        catch (MalformedURLException e) {
            _logger.log(Level.SEVERE, "Exception setting the schemas/dtds location", e);
        }
        this.instanceName = this._serverContext.getInstanceName();
        this.webContainerFeatureFactory = (WebContainerFeatureFactory)this.habitat.getComponent(PEWebContainerFeatureFactoryImpl.class);
        Config cfg = (Config)this.habitat.getComponent(Config.class);
        this.serverConfigLookup = new ServerConfigLookup(cfg, this.clh);
        this.configureDynamicReloadingSettings();
        this.setDebugLevel();
        this.initMonitoringLevel(cfg.getMonitoringService());
        String maxDepth = null;
        if (cfg.getWebContainer() != null) {
            maxDepth = cfg.getWebContainer().getPropertyValue(DISPATCHER_MAX_DEPTH);
        }
        if (maxDepth != null) {
            int depth = -1;
            try {
                depth = Integer.parseInt(maxDepth);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (depth > 0) {
                Request.setMaxDispatchDepth((int)depth);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Maximum depth for nested request dispatches set to " + maxDepth);
                }
            }
        }
        LogService logService = cfg.getLogService();
        String logServiceFile = null;
        if (logService != null) {
            logServiceFile = logService.getFile();
        }
        this._embedded = new EmbeddedWebContainer(this._serverContext, this, logServiceFile);
        this._embedded.setCatalinaHome(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setCatalinaBase(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this.engine = this._embedded.createEngine();
        this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
        this._embedded.addEngine(this.engine);
        ((StandardEngine)this.engine).setDomain(this._serverContext.getDefaultDomainName());
        ((StandardEngine)this.engine).setName(this._serverContext.getDefaultDomainName());
        String serverInfo = System.getProperty("product.name");
        if (serverInfo != null) {
            ServerInfo.setServerInfo((String)serverInfo);
        } else {
            ServerInfo.setServerInfo((String)Version.getVersion());
            System.setProperty("product.name", Version.getVersion());
        }
        if (System.getProperty(DOC_BUILDER_FACTORY_PROPERTY) == null) {
            System.setProperty(DOC_BUILDER_FACTORY_PROPERTY, DOC_BUILDER_FACTORY_IMPL);
        }
        this.initInstanceSessionProperties();
        long btime = 0L;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("before schema check");
            btime = System.currentTimeMillis();
        }
        this.doSchemaCheck();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("after schema check time: " + (System.currentTimeMillis() - btime));
        }
        ConstructorWomb womb = new ConstructorWomb(HttpServiceConfigListener.class, this.habitat, null);
        this.configListener = (HttpServiceConfigListener)womb.get(null);
        ObservableBean httpServiceBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.configListener.httpService);
        httpServiceBean.addListener((ConfigListener)this.configListener);
        this.configListener.setContainer(this);
        this.configListener.setLogger(_logger);
        this.events.register((EventListener)this);
        List configs = this.domain.getConfigs().getConfig();
        for (Config aConfig : configs) {
            HttpService httpService = aConfig.getHttpService();
            List httpListeners = httpService.getHttpListener();
            String jkEnabled = null;
            for (HttpListener httpListener : httpListeners) {
                jkEnabled = httpListener.getPropertyValue("jkEnabled");
                if (jkEnabled != null && ConfigBeansUtilities.toBoolean((String)jkEnabled)) {
                    this.createJKConnector(httpListener, httpService);
                    continue;
                }
                this.createHttpListener(httpListener, httpService);
            }
            this.createJKConnector(null, httpService);
            this.setDefaultRedirectPort(this.defaultRedirectPort);
            this.createHosts(httpService, aConfig.getSecurityService());
        }
        this.loadDefaultWebModules();
        this._started = true;
        try {
            this._embedded.start();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to start web container", le);
            return;
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
            this.isShutdown = true;
        }
    }

    public void preDestroy() {
        try {
            this._embedded.stop();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to stop web container", le);
            return;
        }
    }

    JavaEEObjectStreamFactory getJavaEEObjectStreamFactory() {
        return this.javaEEObjectStreamFactory;
    }

    public ServletProbeProvider getServletProbeProvider() {
        return this.servletProbeProvider;
    }

    public JspProbeProvider getJspProbeProvider() {
        return this.jspProbeProvider;
    }

    public SessionProbeProvider getSessionProbeProvider() {
        return this.sessionProbeProvider;
    }

    public RequestProbeProvider getRequestProbeProvider() {
        return this.requestProbeProvider;
    }

    public WebModuleProbeProvider getWebModuleProbeProvider() {
        return this.webModuleProbeProvider;
    }

    public String getName() {
        return "Web";
    }

    public Class<? extends WebDeployer> getDeployer() {
        return WebDeployer.class;
    }

    public WebConnector getJkConnector() {
        return this.jkConnector;
    }

    protected WebConnector createHttpListener(HttpListener httpListener, HttpService httpService) {
        return this.createHttpListener(httpListener, httpService, null);
    }

    protected WebConnector createHttpListener(HttpListener httpListener, HttpService httpService, Mapper mapper) {
        String address;
        if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue()) {
            return null;
        }
        int port = 8080;
        this.checkHostnameUniqueness(httpListener.getId(), httpService);
        try {
            port = Integer.parseInt(httpListener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, httpListener.getPort(), httpListener.getId());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = Boolean.valueOf(httpListener.getSecurityEnabled());
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = httpListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        WebConnector connector = (WebConnector)this._embedded.createConnector(address, port, isSecure);
        if (mapper != null) {
            connector.setMapper(mapper);
        } else {
            for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
                if (m.getPort() != port) continue;
                connector.setMapper(m);
                break;
            }
        }
        _logger.info("Created HTTP listener " + httpListener.getId() + " on port " + httpListener.getPort());
        connector.setName(httpListener.getId());
        connector.configure(httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector((Connector)connector);
        this.portMap.put(httpListener.getId(), Integer.valueOf(httpListener.getPort()));
        this.connectorMap.put(httpListener.getId(), connector);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        ObservableBean httpListenerBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)httpListener);
        httpListenerBean.addListener((ConfigListener)this.configListener);
        return connector;
    }

    private void createJKConnector(HttpListener httpListener, HttpService httpService) {
        int port = 8009;
        if (httpListener == null) {
            String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
            if (portString == null) {
                return;
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                port = 8009;
            }
        } else {
            port = Integer.parseInt(httpListener.getPort());
        }
        this.jkConnector = (WebConnector)this._embedded.createConnector("0.0.0.0", port, "ajp");
        this.jkConnector.configureJKProperties();
        String defaultHost = "server";
        String jkConnectorName = "jk-connector";
        if (httpListener != null) {
            defaultHost = httpListener.getDefaultVirtualServer();
            jkConnectorName = httpListener.getId();
        }
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setName(jkConnectorName);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.configureHttpProtocol(httpService.getHttpProtocol());
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + port);
        boolean found = false;
        for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
            if (m.getPort() != port) continue;
            found = true;
            this.jkConnector.setMapper(m);
            break;
        }
        this._embedded.addConnector((Connector)this.jkConnector);
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        List httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (connector.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue())) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.globalAccessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.globalAccessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    connector.setProxyHandler(propValue);
                    continue;
                }
                if ("sso-enabled".equals(propName)) {
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List vsListeners = StringUtils.parseStringList((String)vse.getHttpListeners(), (String)",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals(vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList((String)otherVs.getHosts(), (String)",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals(otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected void createHosts(HttpService httpService, SecurityService securityService) {
        List virtualServers = httpService.getVirtualServer();
        for (com.sun.enterprise.config.serverbeans.VirtualServer vs : virtualServers) {
            this.createHost(vs, httpService, securityService);
            _logger.info("Created virtual server " + vs.getId());
        }
    }

    public VirtualServer createHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, SecurityService securityService) {
        PEAccessLogValve accessLogValve;
        boolean startAccessLog;
        MimeMap mm = null;
        String vs_id = vsBean.getId();
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        this.validateDocroot(docroot, vs_id, vsBean.getDefaultWebModule());
        VirtualServer vs = this.createHost(vs_id, vsBean, docroot, mm, httpService.getHttpProtocol());
        Property cacheProp = vsBean.getProperty("setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        if ((startAccessLog = (accessLogValve = vs.getAccessLogValve()).configure(vs_id, vsBean, httpService, this.domain, this.habitat, this.webContainerFeatureFactory, this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval)) && vs.isAccessLoggingEnabled(this.globalAccessLoggingEnabled)) {
            vs.addValve((GlassFishValve)accessLogValve);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, httpService, securityService);
        this.engine.addChild((org.apache.catalina.Container)vs);
        ObservableBean virtualServerBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)vsBean);
        virtualServerBean.addListener((ConfigListener)this.configListener);
        return vs;
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = rb.getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    protected void configureHost(VirtualServer vs, HttpService httpService, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners == null) {
            return;
        }
        HashSet<HttpListener> httpListeners = new HashSet<HttpListener>();
        for (int i = 0; i < listeners.size(); ++i) {
            boolean found = false;
            for (HttpListener httpListener : httpService.getHttpListener()) {
                if (!httpListener.getId().equals(listeners.get(i))) continue;
                httpListeners.add(httpListener);
                found = true;
                break;
            }
            if (found) continue;
            _logger.log(Level.SEVERE, "Listener " + (String)listeners.get(i) + " referenced by virtual server " + vs.getName() + " does not exist");
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
        vs.configureAuthRealm(securityService);
    }

    protected void configureHostPortNumbers(VirtualServer vs, HashSet<HttpListener> httpListeners) {
        boolean addJkListenerPort = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (HttpListener httpListener : httpListeners) {
            if (Boolean.valueOf(httpListener.getEnabled()).booleanValue()) {
                Integer port = this.portMap.get(httpListener.getId());
                if (port == null) continue;
                portsList.add(port);
                continue;
            }
            if (!vs.getName().equalsIgnoreCase("__asadmin")) continue;
            String msg = rb.getString("pewebcontainer.httpListener.mustNotDisable");
            msg = MessageFormat.format(msg, httpListener.getId(), vs.getName());
            throw new IllegalArgumentException(msg);
        }
        int numPorts = portsList.size();
        if (addJkListenerPort) {
            ++numPorts;
        }
        if (numPorts > 0) {
            int[] ports = new int[numPorts];
            int i = 0;
            for (i = 0; i < portsList.size(); ++i) {
                ports[i] = (Integer)portsList.get(i);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Virtual Server " + vs.getID() + " set port " + ports[i]);
            }
            if (addJkListenerPort) {
                ports[i] = this.jkConnector.getPort();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Virtual Server " + vs.getID() + " set jk port " + ports[i]);
                }
            }
            vs.setPorts(ports);
        }
    }

    private void enableVirtualServerMonitoring() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                this.enableVirtualServerMonitoring(vs);
            }
        }
    }

    private void enableVirtualServerMonitoring(VirtualServer vs) {
        ServerContext sc = this.getServerContext();
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)sc.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
        try {
            monitoringRegistry.registerPWCVirtualServerStats((PWCVirtualServerStats)vsStats, vs.getID(), null);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
        }
        PWCRequestStatsImpl pwcRequestStatsImpl = new PWCRequestStatsImpl(sc.getDefaultDomainName());
        vs.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        try {
            monitoringRegistry.registerPWCRequestStats((PWCRequestStats)pwcRequestStatsImpl, vs.getID(), null);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = rb.getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCRequestStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    public void configureKeepAlive(HttpService httpService) {
        KeepAlive keepAlive = httpService.getKeepAlive();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureKeepAlive(keepAlive);
        }
    }

    public void configureConnectionPool(HttpService httpService) {
        ConnectionPool cp = httpService.getConnectionPool();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureConnectionPool(cp);
        }
    }

    public void configureHttpProtocol(HttpService httpService) {
        HttpProtocol httpProtocol = httpService.getHttpProtocol();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureHttpProtocol(httpProtocol);
        }
    }

    public void configureFileCache(HttpService httpService) {
        HttpFileCache httpFileCache = httpService.getHttpFileCache();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureFileCache(httpFileCache);
        }
    }

    public void configureRequestProcessing(HttpService httpService) {
        RequestProcessing rp = httpService.getRequestProcessing();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureRequestProcessing(rp);
        }
    }

    public String getID() {
        return this._id;
    }

    public HealthChecker getHealthChecker() {
        return this._healthChecker;
    }

    private void initHealthChecker() {
        HealthChecker healthChecker = null;
        try {
            healthChecker = this.webContainerFeatureFactory.getHADBHealthChecker(this);
        }
        catch (NoClassDefFoundError ex) {
            _logger.log(Level.WARNING, "hadbhealthchecker.hadbClientJarsMissing");
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer>>initHealthChecker - healthChecker = " + healthChecker);
        }
        if (healthChecker != null) {
            this._healthChecker = healthChecker;
            try {
                this._healthChecker.start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
    }

    private void stopHealthChecker() {
        if (this._healthChecker != null) {
            try {
                this._healthChecker.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
            this._healthChecker = null;
        }
    }

    public VirtualServer createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, MimeMap mimeMap, HttpProtocol httpProtocol) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, vsBean.getLogFile(), mimeMap);
        vs.configureState();
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve(httpProtocol);
        vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
        vs.configureRedirect();
        vs.configureErrorPage();
        return vs;
    }

    private void doSchemaCheck() {
        SchemaUpdater schemaUpdater;
        block5: {
            schemaUpdater = null;
            try {
                schemaUpdater = (SchemaUpdater)this.habitat.getComponent(SchemaUpdater.class);
            }
            catch (NoClassDefFoundError ex) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.fine("HADB Warning - client jars missing - ok if not running with HADB");
            }
        }
        if (schemaUpdater != null) {
            try {
                schemaUpdater.doSchemaCheck();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "schemaupdater.error", ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        ArrayList shutdownCleanupCapablesList;
        WebContainerStartStopOperation startStopOperation;
        block3: {
            if (!this._started) {
                String msg = rb.getString("webcontainer.notStarted");
                throw new LifecycleException(msg);
            }
            this.stopHealthChecker();
            startStopOperation = this.getWebContainerStartStopOperation();
            shutdownCleanupCapablesList = startStopOperation.doPreStop();
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().indexOf("has not been started") != -1) break block3;
                throw ex;
            }
        }
        startStopOperation.doPostStop(shutdownCleanupCapablesList);
    }

    public WebContainerStartStopOperation getWebContainerStartStopOperation() {
        if (this.webContainerFeatureFactory == null) {
            return null;
        }
        WebContainerStartStopOperation startStopOperation = this.webContainerFeatureFactory.getWebContainerStartStopOperation();
        return startStopOperation;
    }

    protected void loadDefaultWebModules() {
        Engine[] engines = this._embedded.getEngines();
        String defaultPath = null;
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || "__asadmin".equals((vs = (VirtualServer)vsArray[i]).getName())) continue;
                WebModuleConfig wmInfo = vs.getDefaultWebModule(this.domain, (WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)));
                if (wmInfo != null) {
                    defaultPath = wmInfo.getContextPath();
                    try {
                        this.updateDefaultWebModule(vs, vs.getPorts(), wmInfo);
                    }
                    catch (LifecycleException le) {
                        String msg = rb.getString("webcontainer.defaultWebModuleError");
                        msg = MessageFormat.format(msg, defaultPath, vs.getName());
                        _logger.log(Level.SEVERE, msg, le);
                    }
                    continue;
                }
                wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)));
                if (wmInfo == null) continue;
                defaultPath = wmInfo.getContextPath();
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        try {
            this.loadWebModule(vs, wmInfo, "null", null);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error loading web module " + wmInfo.getName(), t);
        }
    }

    protected void loadAllJ2EEApplicationWebModules() {
        this.loadAllJ2EEApplicationWebModules(false);
    }

    private void loadAllJ2EEApplicationWebModules(boolean isStartUp) {
        Domain domain = (Domain)this.habitat.getComponent(Domain.class);
        Applications appsBean = domain.getApplications();
        if (appsBean != null) {
            for (J2eeApplication module : appsBean.getModules(J2eeApplication.class)) {
                if (!this.isReferenced(module.getName())) continue;
                this.loadJ2EEApplicationWebModules(module);
            }
        }
    }

    public void loadJ2EEApplicationWebModules(J2eeApplication j2eeAppBean) {
    }

    protected boolean isEnabled(String moduleName) {
        return true;
    }

    public List<Result<WebModule>> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) {
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        boolean loadToAll = vsList == null || vsList.size() == 0;
        Engine[] engines = this._embedded.getEngines();
        ArrayList<Result<WebModule>> results = new ArrayList<Result<WebModule>>();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals("__asadmin") && loadToAll || !loadToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                WebModule ctx = null;
                try {
                    ctx = this.loadWebModule(vs, wmInfo, j2eeApplication, deploymentProperties);
                    results.add((Result<WebModule>)new Result((Object)ctx));
                    continue;
                }
                catch (Throwable t) {
                    if (ctx != null) {
                        ctx.setAvailable(false);
                    }
                    results.add((Result<WebModule>)new Result(t));
                }
            }
        }
        return results;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    private WebModule loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) throws Exception {
        ClassLoader parentLoader;
        WebBundleDescriptor wbd;
        String wmName = wmInfo.getName();
        String wmContextPath = wmInfo.getContextPath();
        if (wmContextPath.equals("") && vs.getDefaultWebModuleID() != null) {
            String msg = rb.getString("webcontainer.defaultWebModuleConflict");
            msg = MessageFormat.format(msg, wmName, wmContextPath, vs.getID());
            throw new Exception(msg);
        }
        if (wmName.indexOf(":") != -1) {
            wmInfo.setWorkDirBase(this._appsWorkRoot);
            wmInfo.setStubBaseDir(this.appsStubRoot);
        } else {
            wmInfo.setWorkDirBase(this._modulesWorkRoot);
            wmInfo.setStubBaseDir(this.modulesStubRoot);
        }
        String displayContextPath = null;
        displayContextPath = wmContextPath.equals("") ? "/" : wmContextPath;
        HashMap adHocPaths = null;
        HashMap adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild((org.apache.catalina.Container)ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getJ2EEApplication(), vs.getName(), true, null);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return ctx;
                }
                String msg = rb.getString("webcontainer.duplicateContextRoot");
                msg = MessageFormat.format(msg, vs.getID(), displayContextPath, wmName);
                throw new Exception(msg);
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
            _logger.log(Level.FINEST, "webcontainer.loadModule", params);
        }
        File docBase = null;
        docBase = JWS_APPCLIENT_MODULE_NAME.equals(wmName) ? new File(System.getProperty("com.sun.aas.installRoot")) : wmInfo.getLocation();
        ctx = (WebModule)this._embedded.createContext(wmName, wmContextPath, docBase, vs.getDefaultContextXmlLocation(), vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo.getDescriptor());
        ctx.setUseNaming(false);
        Engine engine = (Engine)vs.getParent();
        if (engine != null) {
            ctx.setEngineName(engine.getName());
            ctx.setJvmRoute(engine.getJvmRoute());
        }
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setServer(server);
        ctx.setCachingAllowed(false);
        ctx.setCacheControls(vs.getCacheControls());
        ctx.setBean(wmInfo.getBean());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        if ((wbd = wmInfo.getDescriptor()) != null) {
            ctx.setContextRoot(wbd.getContextRoot());
        } else {
            _logger.log(Level.WARNING, "Unable to set context root", wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuilder workDir = new StringBuilder(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename((String)vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        if (wbd != null) {
            ctx.configureAlternateDD(wmInfo, wbd.getModuleDescriptor().getAlternateDescriptor(), this.instance);
            ctx.configureWebServices(wbd);
        }
        SunWebApp iasBean = null;
        if (wbd != null) {
            iasBean = wbd.getSunDescriptor();
        }
        ctx.setIasWebAppConfigBean(iasBean);
        ctx.configureMiscSettings(iasBean, vs, displayContextPath);
        if (ctx.getID().startsWith("__default-web-module")) {
            ctx.setAlternateDocBases(vs.getProperties());
        }
        Loader loader = ctx.configureLoader(iasBean, wmInfo);
        if (wbd != null && wbd.hasWebServices()) {
            wbd.addExtraAttribute("WEBLOADER", (Object)loader);
        }
        ctx.configureSessionSettings(wbd, wmInfo);
        ctx.setI18nInfo();
        if (wbd != null) {
            boolean isSystem;
            String resourceType = wmInfo.getObjectType();
            boolean bl = isSystem = resourceType != null && resourceType.startsWith("system-");
            if (!wmName.startsWith("__default-web-module")) {
                Realm realm = (Realm)this.habitat.getByContract(Realm.class);
                if ("null".equals(j2eeApplication)) {
                    if (realm != null && realm instanceof RealmInitializer) {
                        ((RealmInitializer)realm).initializeRealm((Object)wbd, isSystem, vs.getAuthRealmName());
                        ctx.setRealm(realm);
                    }
                } else if (realm != null && realm instanceof RealmInitializer) {
                    ((RealmInitializer)realm).initializeRealm((Object)wbd, isSystem, null);
                    ctx.setRealm(realm);
                }
            }
            if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                wbd.visit((WebBundleVisitor)new WebValidatorWithoutCL());
            }
        }
        this.addMimeMappings(ctx, vs.getMimeMap());
        if (wbd != null && wbd.getApplication() != null) {
            String moduleName = wbd.getApplication().isVirtual() ? wbd.getApplication().getRegistrationName() : wbd.getModuleDescriptor().getArchiveUri();
            ctx.setModuleName(moduleName);
        } else {
            ctx.setModuleName("__default-web-module");
        }
        vs.addChild((org.apache.catalina.Container)ctx);
        ctx.loadSessions(deploymentProperties);
        return ctx;
    }

    protected void updateDefaultWebModule(VirtualServer virtualServer, int[] ports, WebModuleConfig wmInfo) throws LifecycleException {
        String defaultContextPath = null;
        if (wmInfo != null) {
            defaultContextPath = wmInfo.getContextPath();
        }
        if (defaultContextPath != null && !defaultContextPath.startsWith("/")) {
            defaultContextPath = "/" + defaultContextPath;
            wmInfo.getDescriptor().setContextRoot(defaultContextPath);
        }
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            PECoyoteConnector conn = (PECoyoteConnector)connectors[i];
            int port = conn.getPort();
            for (int j = 0; j < ports.length; ++j) {
                if (port != ports[j]) continue;
                Mapper mapper = conn.getMapper();
                try {
                    mapper.setDefaultContextPath(virtualServer.getName(), defaultContextPath);
                    virtualServer.setDefaultContextPath(defaultContextPath);
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    ServerConfigLookup getServerConfigLookup() {
        return this.serverConfigLookup;
    }

    File getLibPath() {
        return this.instance.getLibPath();
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public File getModulesRoot() {
        return this._modulesRoot;
    }

    private String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props = mgrBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
                break;
            }
        }
        return persistenceFrequency;
    }

    private String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props = storeBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
                break;
            }
        }
        return persistenceScope;
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, Properties props) {
        this.unloadWebModule(contextRoot, appName, virtualServers, false, props);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, boolean dummy, Properties props) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer.unloadWebModule(): contextRoot: " + contextRoot + " appName:" + appName);
        }
        this.cleanSecurityContext(appName);
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        } else if ("/".equals(contextRoot)) {
            contextRoot = "";
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList((String)virtualServers, (String)" ,");
        boolean unloadFromAll = hostList == null || hostList.size() == 0;
        boolean hasBeenUndeployed = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        WebModule context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                WebModuleConfig wmInfo;
                host = (VirtualServer)hostArray[i];
                if (unloadFromAll && host.getName().equalsIgnoreCase("__asadmin") || !unloadFromAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null) continue;
                context.saveSessions(props);
                host.removeChild((org.apache.catalina.Container)context);
                try {
                    if (!this.isShutdown) {
                        context.destroy();
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + contextRoot + " threw exception in destroy()", ex);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " undeployed from " + (Object)((Object)host));
                }
                hasBeenUndeployed = true;
                host.fireContainerEvent("remove", (Object)context);
                if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                    WebModule wm = this.createAdHocWebModule(context.getID(), host, contextRoot, context.getJ2EEApplication());
                    wm.addAdHocPaths(context.getAdHocPaths());
                    wm.addAdHocSubtrees(context.getAdHocSubtrees());
                }
                if (dummy || (wmInfo = host.createSystemDefaultWebModuleIfNecessary((WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)))) == null) continue;
                this.loadStandaloneWebModule(host, wmInfo);
            }
        }
        if (!hasBeenUndeployed) {
            _logger.log(Level.SEVERE, "[WebContainer] Undeployment failed for context " + contextRoot);
        }
    }

    public boolean suspendWebModule(String contextRoot, String appName, String hosts) {
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList((String)hosts, (String)" ,");
        boolean suspendOnAll = hostList == null || hostList.size() == 0;
        boolean hasBeenSuspended = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        Context context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                host = (VirtualServer)hostArray[i];
                if (suspendOnAll && host.getName().equalsIgnoreCase("__asadmin") || !suspendOnAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
                context.setAvailable(false);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " disabled from " + (Object)((Object)host));
                }
                hasBeenSuspended = true;
            }
        }
        if (!hasBeenSuspended) {
            _logger.log(Level.WARNING, "[WebContainer] Unable to disable web module at context root " + contextRoot);
        }
        return hasBeenSuspended;
    }

    private void configureDynamicReloadingSettings() {
        if (this.dasConfig != null) {
            this._reloadingEnabled = Boolean.parseBoolean(this.dasConfig.getDynamicReloadEnabled());
            String seconds = this.dasConfig.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setDebugLevel() {
        Level logLevel;
        Level level = logLevel = _logger.getLevel() != null ? _logger.getLevel() : Level.INFO;
        this._debug = logLevel.equals(Level.FINE) ? 1 : (logLevel.equals(Level.FINER) ? 2 : (logLevel.equals(Level.FINEST) ? 5 : 0));
    }

    private void initMonitoringLevel(MonitoringService monitoringBean) {
        ModuleMonitoringLevels levels;
        monitoringLevel = MonitoringLevel.OFF;
        if (monitoringBean != null && (levels = monitoringBean.getModuleMonitoringLevels()) != null) {
            monitoringLevel = MonitoringLevel.instance((String)levels.getWebContainer());
        }
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    private void cleanSecurityContext(String appName) {
    }

    ArrayList<VirtualServer> getVirtualServersForHttpListenerId(HttpService httpService, String httpListenerId) {
        if (httpListenerId == null) {
            return null;
        }
        ArrayList<VirtualServer> result = new ArrayList<VirtualServer>();
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vs : httpService.getVirtualServer()) {
            List listeners = StringUtils.parseStringList((String)vs.getHttpListeners(), (String)",");
            if (listeners == null) continue;
            ListIterator iter = listeners.listIterator();
            while (iter.hasNext()) {
                if (!httpListenerId.equals(iter.next())) continue;
                VirtualServer match = (VirtualServer)this.getEngines()[0].findChild(vs.getId());
                if (match == null) continue block0;
                result.add(match);
                continue block0;
            }
        }
        return result;
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = (String)itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    private void setTldScan() {
        HashSet<String> tldJars = null;
        HashSet tldListeners = null;
        String prop = System.getProperty("com.sun.enterprise.taglibs");
        if (prop != null && prop.trim().length() > 0) {
            tldJars = new HashSet<String>(StringUtils.parseStringList((String)prop, (String)","));
        }
        if ((prop = System.getProperty("com.sun.enterprise.taglisteners")) != null && prop.trim().length() > 0) {
            tldListeners = new HashSet(StringUtils.parseStringList((String)prop, (String)","));
        }
        if (tldListeners != null && tldListeners.size() > 0) {
            TldConfig.setScanParentTldListener((boolean)true);
        }
        TldConfig.setTldListeners((HashSet)tldListeners);
        TldLocationsCache.setTldJars(tldJars);
    }

    private boolean isReferenced(String appName) {
        Servers servers = this.domain.getServers();
        for (Server server : servers.getServer()) {
            if (!server.getName().equals(this._serverContext.getInstanceName())) continue;
            for (ApplicationRef ref : server.getApplicationRef()) {
                if (!ref.getRef().equals(appName)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerServletStats(String j2eeApplication, String j2eeServer, String webModuleName, String vsId, String contextRoot, String servletName, MonitoringLevelListener listener) {
        PwcServletStatsImpl pwcServletStats = new PwcServletStatsImpl(this._serverContext.getDefaultDomainName(), vsId, contextRoot, servletName, j2eeApplication, j2eeServer);
        ServletStatsImpl servletStats = new ServletStatsImpl(pwcServletStats);
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.habitat.getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerServletStats((ServletStats)servletStats, app, webModuleName, contextRoot, vsId, servletName, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during registration of servletstats", e);
        }
    }

    private void unregisterServletStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId, String servletName) {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.habitat.getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterServletStats(j2eeApplication, webModuleName, contextRoot, vsId, servletName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during unregistration of servletstats", e);
        }
    }

    private WebModuleStats registerWebModuleStats(String j2eeApplication, String j2eeServer, String vsId, WebModule ctx, MonitoringLevelListener listener) {
        WebModuleStatsImpl webStats = (WebModuleStatsImpl)this.webContainerFeatureFactory.getWebModuleStats();
        PwcWebModuleStatsImpl pwcWebStats = new PwcWebModuleStatsImpl(ctx.getObjectName(), ctx.getEncodedPath(), this._serverContext.getDefaultDomainName(), vsId, j2eeApplication, j2eeServer);
        webStats.setPwcWebModuleStats(pwcWebStats);
        webStats.setSessionManager(ctx.getManager());
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.habitat.getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerWebModuleStats((WebModuleStats)webStats, app, ctx.getModuleName(), ctx.getEncodedPath(), vsId, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to register WebModuleStats for " + ctx.getModuleName() + " deployed on " + vsId, e);
        }
        return webStats;
    }

    private void unregisterWebModuleStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId) {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.habitat.getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterWebModuleStats(j2eeApplication, webModuleName, contextRoot, vsId);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to unregister WebModuleStats for " + webModuleName + " deployed on " + vsId, e);
        }
    }

    public Engine[] getEngines() {
        return this._embedded.getEngines();
    }

    public void registerAdHocPath(String id, String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(id, path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String id, String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin")) continue;
                wm = (WebModule)vs.findChild(ctxtRoot);
                if (wm == null) {
                    wm = this.createAdHocWebModule(id, vs, ctxtRoot, appName);
                }
                wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
            }
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin") || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
                wm.removeAdHocPath(path);
                wm.removeAdHocSubtree(subtree);
                if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
                vs.removeChild((org.apache.catalina.Container)wm);
                try {
                    wm.destroy();
                    continue;
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + wm.getPath() + " threw exception in destroy()", ex);
                }
            }
        }
    }

    private WebModule createAdHocWebModule(String id, VirtualServer vs, String ctxtRoot, String appName) {
        AdHocWebModule wm = new AdHocWebModule(id, this);
        wm.restrictedSetPipeline((Pipeline)new WebPipeline((org.apache.catalina.Container)wm));
        wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(appName);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        wm.setServer(server);
        wm.setCrossContext(true);
        vs.addChild((org.apache.catalina.Container)wm);
        return wm;
    }

    void removeDummyModule(VirtualServer vs) {
        WebModule ctx = (WebModule)vs.findChild("");
        if (ctx != null && "__default-web-module".equals(ctx.getModuleName())) {
            this.unloadWebModule("", ctx.getJ2EEApplication(), vs.getName(), true, null);
        }
    }

    private void initInstanceSessionProperties() {
        SessionProperties spBean = this.serverConfigLookup.getInstanceSessionProperties();
        if (spBean == null || spBean.getProperty() == null) {
            return;
        }
        List props = spBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
            }
            if (propName.equalsIgnoreCase("enableCookies")) {
                this.instanceEnableCookies = ConfigBeansUtilities.toBoolean((String)propValue);
                continue;
            }
            Object[] params = new Object[]{propName};
            _logger.log(Level.INFO, "webcontainer.notYet", params);
        }
    }

    private static synchronized void setJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        int i;
        Engine[] engines = this._embedded.getEngines();
        org.apache.catalina.Container[] virtualServers = engines[0].findChildren();
        block2: for (i = 0; i < virtualServers.length; ++i) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
                if (!virtualServers[i].getName().equals(vse.getId())) continue;
                virtualServers[i] = null;
                continue block2;
            }
        }
        for (i = 0; i < virtualServers.length; ++i) {
            VirtualServer virtualServer = (VirtualServer)virtualServers[i];
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            org.apache.catalina.Container[] webModules = virtualServer.findChildren();
            for (int j = 0; j < webModules.length; ++j) {
                this.unloadWebModule(webModules[j].getName(), webModules[j].getName(), virtualServer.getID(), null);
            }
            try {
                virtualServer.destroy();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error during destruction of virtual server " + virtualServer.getID(), e);
            }
        }
    }

    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService) throws LifecycleException {
        WebModuleConfig wmInfo;
        WebConnector conn;
        boolean found;
        int i;
        if ("__asadmin".equals(vsBean.getId())) {
            return;
        }
        Engine[] engines = this._embedded.getEngines();
        VirtualServer virtualServer = (VirtualServer)engines[0].findChild(vsBean.getId());
        if (virtualServer == null) {
            _logger.log(Level.WARNING, "Virtual server " + vsBean.getId() + " cannot be updated, because it does not exist");
            return;
        }
        String oldDefaultWebModule = virtualServer.getDefaultWebModuleID();
        virtualServer.setBean(vsBean);
        virtualServer.setLogFile(vsBean.getLogFile());
        virtualServer.configureState();
        virtualServer.clearAliases();
        virtualServer.configureAliases();
        virtualServer.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        if (docroot != null) {
            this.updateDocroot(docroot, virtualServer, vsBean);
        }
        List<Property> props = virtualServer.getProperties();
        for (Property prop : props) {
            this.updateHostProperties(vsBean, prop.getName(), prop.getValue(), httpService, null);
        }
        int[] oldPorts = virtualServer.getPorts();
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners != null) {
            HashSet<HttpListener> httpListeners = new HashSet<HttpListener>();
            for (i = 0; i < listeners.size(); ++i) {
                found = false;
                for (HttpListener httpListener : httpService.getHttpListener()) {
                    if (!httpListener.getId().equals(listeners.get(i))) continue;
                    httpListeners.add(httpListener);
                    found = true;
                    break;
                }
                if (found) continue;
                _logger.log(Level.SEVERE, "Listener " + (String)listeners.get(i) + " referenced by virtual server " + virtualServer.getName() + " does not exist");
            }
            this.configureHostPortNumbers(virtualServer, httpListeners);
        } else {
            virtualServer.setPorts(new int[0]);
        }
        int[] newPorts = virtualServer.getPorts();
        for (i = 0; i < oldPorts.length; ++i) {
            found = false;
            for (int j = 0; j < newPorts.length; ++j) {
                if (oldPorts[i] != newPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (int k = 0; k < connectors.length; ++k) {
                conn = (WebConnector)connectors[k];
                if (oldPorts[i] != conn.getPort()) continue;
                try {
                    conn.getMapperListener().unregisterHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        for (i = 0; i < newPorts.length; ++i) {
            found = false;
            for (int j = 0; j < oldPorts.length; ++j) {
                if (newPorts[i] != oldPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (int k = 0; k < connectors.length; ++k) {
                conn = (WebConnector)connectors[k];
                if (newPorts[i] != conn.getPort()) continue;
                if (!conn.isAvailable()) {
                    conn.start();
                    this.enableHttpListenerMonitoring(virtualServer, conn.getPort(), conn.getName());
                }
                try {
                    conn.getMapperListener().registerHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        if (oldDefaultWebModule != null) {
            this.updateDefaultWebModule(virtualServer, oldPorts, null);
        }
        if ((wmInfo = virtualServer.getDefaultWebModule(this.domain, (WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)))) != null && wmInfo.getContextPath() != null) {
            this.removeDummyModule(virtualServer);
            this.updateDefaultWebModule(virtualServer, virtualServer.getPorts(), wmInfo);
        } else {
            WebModuleConfig wmc = virtualServer.createSystemDefaultWebModuleIfNecessary((WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)));
            if (wmc != null) {
                this.loadStandaloneWebModule(virtualServer, wmc);
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, HttpService httpService, SecurityService securityService) {
        Engine[] engines = this._embedded.getEngines();
        VirtualServer vs = (VirtualServer)engines[0].findChild(vsBean.getId());
        if (vs == null) {
            return;
        }
        vs.setBean(vsBean);
        if (name == null) {
            return;
        }
        if (name.startsWith("alternatedocroot_")) {
            this.updateAlternateDocroot(vs, vsBean);
        } else if ("setCacheControl".equals(name)) {
            vs.configureCacheControl(value);
        } else if ("accessLoggingEnabled".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accesslog".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogWriteInterval".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogBufferSize".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            vs.configureRemoteHostFilterValve(httpService.getHttpProtocol());
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            vs.configureRemoteAddressFilterValve();
        } else if ("sso-enabled".equals(name)) {
            vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
        } else if ("authRealm".equals(name)) {
            vs.configureAuthRealm(securityService);
        } else if (name.startsWith("send-error")) {
            vs.configureErrorPage();
        } else if (name.startsWith("redirect")) {
            vs.configureRedirect();
        } else if (name.startsWith("contextXmlDefault")) {
            vs.setDefaultContextXmlLocation(value);
        }
    }

    public void updateHttpService(HttpService httpService) throws LifecycleException {
        List httpListeners;
        List virtualServers;
        if (httpService == null) {
            return;
        }
        Property ssoEnabled = null;
        Property accessLoggingEnabled = null;
        Property accessLogWriteInterval = null;
        Property accessLogBufferSize = null;
        List props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                if ("sso-enabled".equals(prop.getName())) {
                    ssoEnabled = prop;
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)prop.getValue());
                    continue;
                }
                if ("accessLoggingEnabled".equals(prop.getName())) {
                    accessLoggingEnabled = prop;
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)prop.getValue());
                    continue;
                }
                if ("accessLogWriteInterval".equals(prop.getName())) {
                    accessLogWriteInterval = prop;
                    this.globalAccessLogWriteInterval = prop.getValue();
                    continue;
                }
                if (!"accessLogBufferSize".equals(prop.getName())) continue;
                accessLogBufferSize = prop;
                this.globalAccessLogBufferSize = prop.getValue();
            }
        }
        if ((virtualServers = httpService.getVirtualServer()) != null && (ssoEnabled != null || accessLoggingEnabled != null || accessLogWriteInterval != null || accessLogBufferSize != null)) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer virtualServer : virtualServers) {
                if (ssoEnabled != null) {
                    this.updateHostProperties(virtualServer, ssoEnabled.getName(), ssoEnabled.getValue(), httpService, null);
                }
                if (accessLoggingEnabled != null) {
                    this.updateHostProperties(virtualServer, accessLoggingEnabled.getName(), accessLoggingEnabled.getValue(), httpService, null);
                }
                if (accessLogWriteInterval != null) {
                    this.updateHostProperties(virtualServer, accessLogWriteInterval.getName(), accessLogWriteInterval.getValue(), httpService, null);
                }
                if (accessLogBufferSize != null) {
                    this.updateHostProperties(virtualServer, accessLogBufferSize.getName(), accessLogBufferSize.getValue(), httpService, null);
                }
                this.updateHost(virtualServer, httpService);
            }
        }
        if ((httpListeners = httpService.getHttpListener()) != null) {
            for (HttpListener httpListener : httpListeners) {
                this.updateConnector(httpListener, httpService);
            }
        }
    }

    public void updateConnectorProperty(HttpListener httpListener, String propName, String propValue) throws LifecycleException {
        WebConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            connector.configureHttpListenerProperty(propName, propValue);
        }
    }

    public void updateConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        if (httpListener.getDefaultVirtualServer().equals("__asadmin") || "http-listener-1".equals(httpListener.getId()) && this.connectorMap.get("admin-listener") == null) {
            return;
        }
        WebConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            this.deleteConnector(connector);
        }
        if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue()) {
            return;
        }
        connector = this.addConnector(httpListener, httpService, false);
        ArrayList<VirtualServer> virtualServers = this.getVirtualServersForHttpListenerId(httpService, httpListener.getId());
        if (virtualServers != null) {
            Mapper mapper = connector.getMapper();
            for (VirtualServer vs : virtualServers) {
                String defaultWebModulePath;
                boolean found = false;
                int[] ports = vs.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] != connector.getPort()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    int[] newPorts = new int[ports.length + 1];
                    System.arraycopy(ports, 0, newPorts, 0, ports.length);
                    newPorts[ports.length] = connector.getPort();
                    vs.setPorts(newPorts);
                }
                if ((defaultWebModulePath = vs.getDefaultContextPath((Domain)this.habitat.getComponent(Domain.class), (WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)))) == null) continue;
                try {
                    mapper.setDefaultContextPath(vs.getName(), defaultWebModulePath);
                    vs.setDefaultContextPath(defaultWebModulePath);
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        connector.start();
    }

    public WebConnector addConnector(HttpListener httpListener, HttpService httpService, boolean start) throws LifecycleException {
        WebConnector connector;
        this.grizzlyService.createNetworkProxy(httpListener, httpService);
        this.grizzlyService.registerNetworkProxy();
        int port = Integer.parseInt(httpListener.getPort());
        String virtualServerName = httpListener.getDefaultVirtualServer();
        VirtualServer vs = (VirtualServer)this._embedded.getEngines()[0].findChild(virtualServerName);
        int[] oldPorts = vs.getPorts();
        int[] newPorts = new int[oldPorts.length + 1];
        System.arraycopy(oldPorts, 0, newPorts, 0, oldPorts.length);
        newPorts[oldPorts.length] = port;
        vs.setPorts(newPorts);
        Mapper mapper = null;
        for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
            if (m.getPort() != port) continue;
            mapper = m;
            break;
        }
        if ((connector = this.createHttpListener(httpListener, httpService, mapper)).getRedirectPort() == -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        if (start) {
            connector.start();
        }
        return connector;
    }

    public void deleteConnector(WebConnector connector) throws LifecycleException {
        int port = connector.getPort();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector conn = (WebConnector)connectors[i];
            if (port != conn.getPort()) continue;
            this._embedded.removeConnector((Connector)conn);
            this.grizzlyService.removeNetworkProxy(port);
            this.portMap.remove(connector.getName());
            this.connectorMap.remove(connector.getName());
        }
    }

    public void deleteConnector(HttpListener httpListener) throws LifecycleException {
        Connector[] connectors = this._embedded.findConnectors();
        int port = Integer.parseInt(httpListener.getPort());
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector conn = (WebConnector)connectors[i];
            if (port != conn.getPort()) continue;
            this._embedded.removeConnector((Connector)conn);
            this.grizzlyService.removeNetworkProxy(port);
            this.portMap.remove(httpListener.getId());
            this.connectorMap.remove(httpListener.getId());
        }
    }

    public void updateAccessLog(HttpService httpService) {
        org.apache.catalina.Container[] virtualServers = this._embedded.getEngines()[0].findChildren();
        for (int i = 0; i < virtualServers.length; ++i) {
            ((VirtualServer)virtualServers[i]).reconfigureAccessLog(httpService, this.webContainerFeatureFactory);
        }
    }

    private void updateDocroot(String docroot, VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        boolean isValid = this.validateDocroot(docroot, vsBean.getId(), vsBean.getDefaultWebModule());
        if (isValid) {
            vs.setAppBase(docroot);
            this.removeDummyModule(vs);
            WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)));
            if (wmInfo != null) {
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    private void updateAlternateDocroot(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebDeployer)((Object)this.habitat.getComponent(WebDeployer.class)));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    protected void enableHttpListenerMonitoring(VirtualServer virtualServer, int port, String httpListenerId) {
        PWCRequestStatsImpl pwcRequestStatsImpl = virtualServer.getPWCRequestStatsImpl();
        if (pwcRequestStatsImpl == null) {
            pwcRequestStatsImpl = new PWCRequestStatsImpl(this.getServerContext().getDefaultDomainName());
            virtualServer.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        }
        MonitoringRegistry mReg = (MonitoringRegistry)this.getServerContext().getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String vsId = virtualServer.getID();
        HTTPListenerStatsImpl httpStats = this.isTomcatUsingDefaultDomain() ? new HTTPListenerStatsImpl(this.getServerContext().getDefaultDomainName(), port) : new HTTPListenerStatsImpl(vsId, port);
        try {
            mReg.registerHttpListenerStats((HTTPListenerStats)httpStats, httpListenerId, vsId, null);
            pwcRequestStatsImpl.addHttpListenerStats(httpStats);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = rb.getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "HTTPListenerStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    private void createProbeProviders() {
        try {
            this.webModuleProbeProvider = (WebModuleProbeProvider)this.probeProviderFactory.getProbeProvider("web", "webmodule", null, WebModuleProbeProvider.class);
            if (this.webModuleProbeProvider == null) {
                _logger.log(Level.WARNING, "Unable to create probe provider for interface " + WebModuleProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Unable to create probe provider for interface " + WebModuleProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (this.webModuleProbeProvider == null) {
            this.webModuleProbeProvider = NO_OP_WEBMODULE_PROBE_PROVIDER;
        }
        try {
            this.servletProbeProvider = (ServletProbeProvider)this.probeProviderFactory.getProbeProvider("web", "servlet", null, ServletProbeProvider.class);
            if (this.servletProbeProvider == null) {
                _logger.log(Level.WARNING, "Unable to create probe provider for interface " + ServletProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Unable to create probe provider for interface " + ServletProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (this.servletProbeProvider == null) {
            this.servletProbeProvider = NO_OP_SERVLET_PROBE_PROVIDER;
        }
        try {
            this.jspProbeProvider = (JspProbeProvider)this.probeProviderFactory.getProbeProvider("web", "jsp", null, JspProbeProvider.class);
            if (this.jspProbeProvider == null) {
                _logger.log(Level.WARNING, "Unable to create probe provider for interface " + JspProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Unable to create probe provider for interface " + JspProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (this.jspProbeProvider == null) {
            this.jspProbeProvider = NO_OP_JSP_PROBE_PROVIDER;
        }
        try {
            this.sessionProbeProvider = (SessionProbeProvider)this.probeProviderFactory.getProbeProvider("web", "session", null, SessionProbeProvider.class);
            if (this.sessionProbeProvider == null) {
                _logger.log(Level.WARNING, "Unable to create probe provider for interface " + SessionProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Unable to create probe provider for interface " + SessionProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (this.sessionProbeProvider == null) {
            this.sessionProbeProvider = NO_OP_SESSION_PROBE_PROVIDER;
        }
        try {
            this.requestProbeProvider = (RequestProbeProvider)this.probeProviderFactory.getProbeProvider("web", "request", null, RequestProbeProvider.class);
            if (this.requestProbeProvider == null) {
                _logger.log(Level.WARNING, "Unable to create probe provider for interface " + RequestProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Unable to create probe provider for interface " + RequestProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (this.requestProbeProvider == null) {
            this.requestProbeProvider = NO_OP_REQUEST_PROBE_PROVIDER;
        }
    }

    static {
        useDOLforDeployment = true;
        rb = Constants.WEB_RESOURCE_BUNDLE;
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
    }

    public static class NoopInvocationHandler
    implements InvocationHandler {
        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }
}

