/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.solaris;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Service;

@Service
public final class SolarisRealm
extends IASRealm {
    public static final String AUTH_TYPE = "solaris";
    private HashMap groupCache;
    private Vector emptyVector;

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("realmconfig.noctx");
            }
            String msg = sm.getString("solarisrealm.nojaas");
            throw new BadRealmException(msg);
        }
        this.setProperty("jaas-context", jaasCtx);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SolarisRealm : jaas-context=" + jaasCtx);
        }
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector v = (Vector)this.groupCache.get(username);
        if (v == null) {
            v = this.loadGroupNames(username);
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = null;
        if (groups == null) {
            v = this.emptyVector;
        } else {
            v = new Vector<String>(groups.length + 1);
            for (int i = 0; i < groups.length; ++i) {
                v.add(groups[i]);
            }
        }
        SolarisRealm solarisRealm = this;
        synchronized (solarisRealm) {
            this.groupCache.put(username, v);
        }
    }

    public String[] authenticate(String username, String password) {
        String[] grps = SolarisRealm.nativeAuthenticate(username, password);
        if (grps != null) {
            grps = this.addAssignGroups(grps);
        }
        this.setGroupNames(username, grps);
        return grps;
    }

    private Vector loadGroupNames(String username) {
        String[] grps = SolarisRealm.nativeGetGroups(username);
        if (grps == null) {
            _logger.fine("No groups returned for user: " + username);
        }
        grps = this.addAssignGroups(grps);
        this.setGroupNames(username, grps);
        return (Vector)this.groupCache.get(username);
    }

    private static native String[] nativeAuthenticate(String var0, String var1);

    private static native String[] nativeGetGroups(String var0);

    static {
        System.loadLibrary("solarisauth");
    }
}

