/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-virtual-server")
@Scoped(value=PerLookup.class)
@I18n(value="delete.virtual.server")
public class DeleteVirtualServer
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteVirtualServer.class);
    @Param(name="virtual_server_id", primary=true)
    String vsid;
    @Inject
    HttpService httpService;
    @Inject
    Server server;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.exists()) {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.notexists", "{0} doesn't exist", new Object[]{this.vsid}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String referencedBy = this.getReferencingListener();
        if (referencedBy != null && referencedBy != "") {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.referenced", "Virtual Server, {0} can not be deleted because it is referenced from http listener, {1}", new Object[]{this.vsid, referencedBy}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ArrayList<ApplicationRef> appRefs = new ArrayList<ApplicationRef>();
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (appRef.getVirtualServers() == null || !appRef.getVirtualServers().contains(this.vsid)) continue;
                appRefs.add(appRef);
            }
            ConfigBeanProxy[] proxies = new ConfigBeanProxy[appRefs.size() + 1];
            proxies[0] = this.httpService;
            for (int i = 0; i < appRefs.size(); ++i) {
                proxies[i + 1] = (ConfigBeanProxy)appRefs.get(i);
            }
            ConfigSupport.apply((ConfigCode)new Config(this.vsid), (ConfigBeanProxy[])proxies);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.fail", "{0} delete failed ", new Object[]{this.vsid}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        if (this.vsid == null) {
            return false;
        }
        List list = this.httpService.getVirtualServer();
        for (VirtualServer vs : list) {
            String currId = vs.getId();
            if (currId == null || !currId.equals(this.vsid)) continue;
            return true;
        }
        return false;
    }

    private String getReferencingListener() {
        List list = this.httpService.getHttpListener();
        for (HttpListener listener : list) {
            String virtualServer = listener.getDefaultVirtualServer();
            if (virtualServer == null || !virtualServer.equals(this.vsid)) continue;
            return listener.getId();
        }
        return null;
    }

    private static class Config
    implements ConfigCode {
        private String vsid;

        private Config(String vsid) {
            this.vsid = vsid;
        }

        public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
            List list = ((HttpService)proxies[0]).getVirtualServer();
            for (VirtualServer item : list) {
                String currId = item.getId();
                if (currId == null || !currId.equals(this.vsid)) continue;
                list.remove(item);
                break;
            }
            if (proxies.length > 1) {
                for (int i = 1; i < proxies.length; ++i) {
                    ApplicationRef appRef = (ApplicationRef)proxies[i];
                    StringBuilder newList = new StringBuilder();
                    StringTokenizer st = new StringTokenizer(appRef.getVirtualServers(), ",");
                    while (st.hasMoreTokens()) {
                        String id = st.nextToken();
                        if (id.equals(this.vsid)) continue;
                        if (newList.length() > 0) {
                            newList.append(",");
                        }
                        newList.append(id);
                    }
                    appRef.setVirtualServers(newList.toString());
                }
            }
            return list;
        }
    }
}

