/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbReferenceNode
extends DeploymentDescriptorNode {
    protected EjbReference descriptor;

    public EjbReferenceNode() {
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbReference)DescriptorFactory.getDescriptor(this.getXMLPath());
            this.descriptor.setLocal(false);
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-ref-name", "setName");
        table.put("ejb-ref-type", "setType");
        table.put("home", "setEjbHomeInterface");
        table.put("remote", "setEjbInterface");
        table.put("local-home", "setEjbHomeInterface");
        table.put("local", "setEjbInterface");
        table.put("ejb-link", "setLinkName");
        table.put("mapped-name", "setMappedName");
        return table;
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbReference descriptor) {
        Element ejbRefNode = EjbReferenceNode.appendChild(parent, nodeName);
        if (descriptor instanceof Descriptor) {
            Descriptor ejbRefDesc = (Descriptor)((Object)descriptor);
            this.writeLocalizedDescriptions(ejbRefNode, ejbRefDesc);
        }
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-ref-name", descriptor.getName());
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-ref-type", descriptor.getType());
        if (descriptor.isLocal()) {
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "local-home", descriptor.getEjbHomeInterface());
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "local", descriptor.getEjbInterface());
        } else {
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "home", descriptor.getEjbHomeInterface());
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "remote", descriptor.getEjbInterface());
        }
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-link", descriptor.getLinkName());
        if (descriptor instanceof EnvironmentProperty) {
            EnvironmentProperty envProp = (EnvironmentProperty)((Object)descriptor);
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "mapped-name", envProp.getMappedName());
        }
        if (descriptor.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : descriptor.getInjectionTargets()) {
                ijNode.writeDescriptor((Node)ejbRefNode, "injection-target", target);
            }
        }
        return ejbRefNode;
    }
}

