/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.ServletMappingNode;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.URLPattern;
import java.util.Enumeration;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebResourceCollectionNode
extends DeploymentDescriptorNode {
    private WebResourceCollectionImpl descriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletMappingNode.class);

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (WebResourceCollectionImpl)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return new XMLElement("web-resource-collection");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("web-resource-name", "setName");
        table.put("http-method", "addHttpMethod");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("url-pattern".equals(element.getQName())) {
            Object parent = this.getParentNode().getParentNode().getDescriptor();
            if (parent instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !value.startsWith("/") && !value.startsWith("*.")) {
                value = "/" + value;
            }
            if (!URLPattern.isValid((String)value)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.invalidurlpattern", "Invalid URL Pattern: [{0}]", new Object[]{value}));
            }
            this.descriptor.addUrlPattern(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebResourceCollectionImpl descriptor) {
        Element myNode = WebResourceCollectionNode.appendChild(parent, nodeName);
        WebResourceCollectionNode.appendTextChild((Node)myNode, "web-resource-name", descriptor.getName());
        this.writeLocalizedDescriptions(myNode, descriptor);
        Enumeration urlPatterns = descriptor.getUrlPatterns();
        while (urlPatterns.hasMoreElements()) {
            WebResourceCollectionNode.appendTextChild((Node)myNode, "url-pattern", (String)urlPatterns.nextElement());
        }
        Enumeration httpMethods = descriptor.getHttpMethods();
        while (httpMethods.hasMoreElements()) {
            WebResourceCollectionNode.appendTextChild((Node)myNode, "http-method", (String)httpMethods.nextElement());
        }
        return myNode;
    }
}

