/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Catalog {
    Image image;
    String authname;
    File cfile;
    File afile;
    List<Fmri> pkg_fmris = new ArrayList<Fmri>();

    public Catalog(Image img, String authname) throws IOException {
        this.image = img;
        this.authname = authname;
        File catroot = new File(this.getCatalogDir(), authname);
        this.cfile = new File(catroot, "catalog");
        this.afile = new File(catroot, "attrs");
        if (this.cfile.exists()) {
            this.load();
        }
    }

    private void load() throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(this.cfile));
        this.pkg_fmris.clear();
        while ((line = r.readLine()) != null) {
            String[] tokens = line.split(" ");
            if (tokens.length != 4 || !tokens[0].equals("V")) continue;
            try {
                Fmri p = new Fmri(tokens[2], tokens[3]);
                this.pkg_fmris.add(p);
            }
            catch (Exception ex) {
                Logger.getLogger(Catalog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        r.close();
    }

    public void refresh() throws IOException {
        String line;
        HttpURLConnection urlc = this.image.getRepositoryURLConnection("catalog/0", this.authname);
        this.image.checkRepositoryConnection(urlc);
        byte[] buf = new byte[4096];
        BufferedReader ir = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        new File(this.cfile.getParent()).mkdirs();
        BufferedWriter cw = new BufferedWriter(new FileWriter(this.cfile));
        BufferedWriter aw = new BufferedWriter(new FileWriter(this.afile));
        while ((line = ir.readLine()) != null) {
            if (!Character.isWhitespace(line.charAt(1))) continue;
            if ("CSVR".indexOf(line.charAt(0)) == -1 || line.startsWith("R ")) {
                cw.write(line);
                cw.newLine();
                continue;
            }
            if (line.startsWith("S ")) {
                aw.write(line);
                aw.newLine();
                continue;
            }
            Fmri f = new Fmri(line.substring(2));
            cw.write(line.substring(0, 1) + " pkg " + f.name + " " + f.version);
            cw.newLine();
        }
        ir.close();
        cw.close();
        aw.close();
        this.load();
        new File(this.getCatalogDir(), "catalog.pkl").delete();
    }

    public int size() {
        return this.pkg_fmris.size();
    }

    public List<Fmri> getFmris() {
        return this.pkg_fmris;
    }

    File getCatalogDir() {
        return new File(this.image.getMetaDirectory(), "catalog");
    }
}

