/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.j2ee.J2EELogicalServer;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.JVM;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.j2ee.J2EELogicalServerImplBase;
import org.glassfish.admin.amx.mbean.Delegate;
import org.glassfish.admin.amx.util.Issues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEServerImpl
extends J2EELogicalServerImplBase {
    private static final String serverVendor = "Sun Microsystems, Inc.";
    private static final Set<String> RESOURCE_TYPES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"JDBCResource", "JavaMailResource", "JCAResource", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URL_Resource"});
    private static final Set<String> DONT_MAP_SET = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"serverVendor"});

    public J2EEServerImpl(String fullType, ObjectName parentObjectName, Delegate delegate) {
        super("J2EEServer", fullType, parentObjectName, (Class<? extends J2EELogicalServer>)J2EEServer.class, delegate);
    }

    private J2EEServer getSelfProxy() {
        return (J2EEServer)this.getSelf();
    }

    public String[] getjavaVMs() {
        JVM jvm = this.getSelfProxy().getJVM();
        String[] result = null;
        result = jvm == null ? new String[]{} : new String[]{"" + Util.getObjectName((AMX)jvm)};
        return result;
    }

    public String[] getresources() {
        return GSetUtil.toStringArray(this.getResourcesObjectNameSet());
    }

    public Set<ObjectName> getResourcesObjectNameSet() {
        return this.getContaineeObjectNameSet(RESOURCE_TYPES);
    }

    public String getserverVersion() {
        Issues.getAMXIssues().notDone("How to get the server version");
        return "Glassfish V3";
    }

    @Override
    public boolean isstatisticProvider() {
        return false;
    }

    @Override
    public boolean isstatisticsProvider() {
        return this.isstatisticProvider();
    }

    public String getserverVendor() {
        return serverVendor;
    }

    @Override
    protected Set<String> getDontMapAttributeNames() {
        return GSetUtil.newSet(DONT_MAP_SET, super.getDontMapAttributeNames());
    }

    @Override
    protected final Set<String> getFauxChildTypes() {
        Issues.getAMXIssues().notDone("J2EEServerImpl.getFauxChildTypes");
        return GSetUtil.newUnmodifiableStringSet((String[])new String[]{"WebModule", "EJBModule"});
    }

    @Override
    public final Set<ObjectName> getContaineeObjectNameSet(String childJ2EEType) {
        Set<ObjectName> result = super.getContaineeObjectNameSet(childJ2EEType);
        if (this.getFauxChildTypes().contains(childJ2EEType)) {
            String nullAppProp = Util.makeProp((String)"J2EEApplication", (String)"null");
            Set<ObjectName> fauxContainees = this.getFauxContaineeObjectNameSet(childJ2EEType, nullAppProp);
            result.addAll(fauxContainees);
        }
        return result;
    }
}

