/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecuritySupportImpl
implements SecuritySupport {
    private static final String keyStoreProp = "javax.net.ssl.keyStore";
    private static final String trustStoreProp = "javax.net.ssl.trustStore";
    protected static final Logger _logger = LogDomains.getLogger(SecuritySupportImpl.class, (String)"javax.enterprise.system.core.security");
    protected static boolean initialized = false;
    protected static final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    protected static final List<KeyStore> trustStores = new ArrayList<KeyStore>();
    protected static final List<String> keyStorePasswords = new ArrayList<String>();
    protected static final List<String> tokenNames = new ArrayList<String>();

    public SecuritySupportImpl() {
        this(true);
    }

    protected SecuritySupportImpl(boolean init) {
        if (init) {
            this.initJKS();
        }
    }

    protected void initJKS() {
        if (!initialized) {
            SecuritySupportImpl.loadStores(null, KeyStore.getDefaultType(), null, System.getProperty(keyStoreProp), SSLUtils.getKeyStorePass(), System.getProperty(trustStoreProp), SSLUtils.getTrustStorePass());
            initialized = true;
        }
    }

    protected static synchronized void loadStores(String tokenName, String storeType, Provider provider, String keyStoreFile, String keyStorePass, String trustStoreFile, String trustStorePass) {
        try {
            KeyStore keyStore = SecuritySupportImpl.loadKS(storeType, provider, keyStoreFile, keyStorePass);
            KeyStore trustStore = SecuritySupportImpl.loadKS(storeType, provider, trustStoreFile, trustStorePass);
            keyStores.add(keyStore);
            trustStores.add(trustStore);
            keyStorePasswords.add(keyStorePass);
            tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKS(String keyStoreType, Provider provider, String keyStoreFile, String keyStorePass) throws Exception {
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] passphrase = keyStorePass.toCharArray();
        FileInputStream istream = null;
        BufferedInputStream bstream = null;
        try {
            if (keyStoreFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = " + keyStoreFile + ", keystorePass = " + keyStorePass);
                }
                istream = new FileInputStream(keyStoreFile);
                bstream = new BufferedInputStream(istream);
            }
            ks.load(bstream, passphrase);
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        return ks;
    }

    public KeyStore[] getKeyStores() {
        return keyStores.toArray(new KeyStore[keyStores.size()]);
    }

    public KeyStore[] getTrustStores() {
        return trustStores.toArray(new KeyStore[trustStores.size()]);
    }

    public String[] getKeyStorePasswords() {
        return keyStorePasswords.toArray(new String[keyStorePasswords.size()]);
    }

    public String[] getTokenNames() {
        return tokenNames.toArray(new String[tokenNames.size()]);
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return trustStores.get(idx);
    }

    public String getKeyStorePassword(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return keyStorePasswords.get(idx);
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = tokenNames.indexOf(token)) < 0 && _logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "token " + token + " is not found");
        }
        return idx;
    }

    public void synchronizeKeyFile(Object configContext, String fileRealmName) throws Exception {
    }

    public CallbackHandler getAppContainerCallbackHandler() {
        throw new UnsupportedOperationException("Not supported yet in V3.");
    }
}

