/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.X509KeyManager;

public class UnifiedX509KeyManager
implements X509KeyManager {
    private X509KeyManager[] mgrs = null;
    private String[] tokenNames = null;

    public UnifiedX509KeyManager(X509KeyManager[] mgrs, String[] tokenNames) {
        if (mgrs == null || tokenNames == null) {
            throw new IllegalArgumentException("Null array of X509KeyManagers or tokenNames");
        }
        if (mgrs.length != tokenNames.length) {
            throw new IllegalArgumentException("Size of X509KeyManagers array and tokenNames array do not match.");
        }
        this.mgrs = mgrs;
        this.tokenNames = tokenNames;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        for (int i = 0; i < this.mgrs.length && (alias = this.mgrs[i].chooseClientAlias(keyType, issuers, socket)) == null; ++i) {
        }
        return alias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        for (int i = 0; i < this.mgrs.length && (alias = this.mgrs[i].chooseServerAlias(keyType, issuers, socket)) == null; ++i) {
        }
        return alias;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain = null;
        for (int i = 0; i < this.mgrs.length && (chain = this.mgrs[i].getCertificateChain(alias)) == null; ++i) {
        }
        return chain;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> clientAliases = new ArrayList<String>();
        for (int i = 0; i < this.mgrs.length; ++i) {
            String[] clAliases = this.mgrs[i].getClientAliases(keyType, issuers);
            if (clAliases == null || clAliases.length <= 0) continue;
            for (int j = 0; j < clAliases.length; ++j) {
                clientAliases.add(clAliases[j]);
            }
        }
        return clientAliases.size() == 0 ? null : clientAliases.toArray(new String[clientAliases.size()]);
    }

    public PrivateKey getPrivateKey(String alias) {
        PrivateKey privKey = null;
        for (int i = 0; i < this.mgrs.length && (privKey = this.mgrs[i].getPrivateKey(alias)) == null; ++i) {
        }
        return privKey;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> serverAliases = new ArrayList<String>();
        for (int i = 0; i < this.mgrs.length; ++i) {
            String[] serAliases = this.mgrs[i].getClientAliases(keyType, issuers);
            if (serAliases == null || serAliases.length <= 0) continue;
            for (int j = 0; j < serAliases.length; ++j) {
                serverAliases.add(serAliases[j]);
            }
        }
        return serverAliases.size() == 0 ? null : serverAliases.toArray(new String[serverAliases.size()]);
    }

    X509KeyManager[] getX509KeyManagers() {
        X509KeyManager[] kmgrs = new X509KeyManager[this.mgrs.length];
        System.arraycopy(this.mgrs, 0, kmgrs, 0, this.mgrs.length);
        return kmgrs;
    }

    String[] getTokenNames() {
        String[] tokens = new String[this.tokenNames.length];
        System.arraycopy(this.tokenNames, 0, tokens, 0, this.tokenNames.length);
        return tokens;
    }
}

