/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        String record = null;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record != null) {
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            this.logger.logp(this.level, "", "", record);
        }
    }
}

