/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.strategy.ResourceSelectionStrategy;
import java.util.ArrayList;

public class ListDataStructure
implements DataStructure {
    private final ArrayList<ResourceHandle> free;
    private final ArrayList<ResourceHandle> resources;
    private int maxSize;
    private ResourceHandler handler;
    private ResourceSelectionStrategy strategy;

    public ListDataStructure(String parameters, int maxSize, ResourceHandler handler, String strategyClass) {
        this.resources = new ArrayList(maxSize);
        this.free = new ArrayList(maxSize);
        this.maxSize = maxSize;
        this.handler = handler;
        this.initializeStrategy(strategyClass);
    }

    private void initializeStrategy(String strategyClass) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ResourceAllocator allocator, int count) throws PoolingException {
        try {
            for (int i = 0; i < count && this.resources.size() < this.maxSize; ++i) {
                ResourceHandle handle = this.handler.createResource(allocator);
                ArrayList<ResourceHandle> arrayList = this.resources;
                synchronized (arrayList) {
                    ArrayList<ResourceHandle> arrayList2 = this.free;
                    synchronized (arrayList2) {
                        this.free.add(handle);
                        this.resources.add(handle);
                    }
                }
            }
        }
        catch (Exception e) {
            PoolingException pe = new PoolingException(e.getMessage());
            pe.initCause((Throwable)e);
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource() {
        ResourceHandle resource = null;
        if (this.strategy != null) {
            resource = this.strategy.retrieveResource();
        } else {
            ArrayList<ResourceHandle> arrayList = this.free;
            synchronized (arrayList) {
                if (this.free.size() > 0) {
                    resource = this.free.remove(0);
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(ResourceHandle resource) {
        ArrayList<ResourceHandle> arrayList = this.resources;
        synchronized (arrayList) {
            ArrayList<ResourceHandle> arrayList2 = this.free;
            synchronized (arrayList2) {
                this.free.remove(resource);
                this.resources.remove(resource);
            }
        }
        this.handler.deleteResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnResource(ResourceHandle resource) {
        ArrayList<ResourceHandle> arrayList = this.free;
        synchronized (arrayList) {
            this.free.add(resource);
        }
    }

    public int getFreeListSize() {
        return this.free.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList<ResourceHandle> arrayList = this.resources;
        synchronized (arrayList) {
            ArrayList<ResourceHandle> arrayList2 = this.free;
            synchronized (arrayList2) {
                while (this.resources.size() > 0) {
                    ResourceHandle handle = this.resources.remove(0);
                    this.free.remove(handle);
                    this.handler.deleteResource(handle);
                }
            }
        }
        this.free.clear();
        this.resources.clear();
    }

    public int getResourcesSize() {
        return this.resources.size();
    }
}

