/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainOSGi;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ASMainEquinox
extends ASMainOSGi {
    private static File pluginsDir = null;

    public ASMainEquinox(Logger logger, String ... args) {
        super(logger, args);
    }

    protected void setFwDir() {
        String fwPath = System.getenv("EQUINOX_HOME");
        if (fwPath == null) {
            fwPath = new File(this.glassfishDir, "equinox").getAbsolutePath();
        }
        this.fwDir = new File(fwPath);
        if (!this.fwDir.exists()) {
            this.fwDir = new File(this.glassfishDir, "eclipse");
            if (this.fwDir.exists() && !(pluginsDir = new File(this.fwDir, "plugins")).exists()) {
                pluginsDir = null;
            }
        }
        if (!this.fwDir.exists()) {
            throw new RuntimeException("Can't locate Equinox at " + fwPath);
        }
    }

    protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
        if (pluginsDir != null) {
            cpb.addGlob(pluginsDir, "org.eclipse.osgi_*.jar");
        } else {
            cpb.addJarFolder(this.fwDir, new String[0]);
        }
    }

    protected void launchOSGiFW() throws Exception {
        System.setProperty("osgi.configuration.area", new File(this.fwDir, "configuration").getCanonicalPath());
        System.setProperty("osgi.clean", "true");
        Class<?> mc = this.launcherCL.loadClass(this.getFWMainClassName());
        final String[] args = new String[]{};
        final Method m = mc.getMethod("main", args.getClass());
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    m.invoke(null, new Object[]{args});
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "OSGi Framework Launcher");
        launcherThread.start();
        launcherThread.join();
        this.logger.info("Framework successfully started");
    }

    private String getFWMainClassName() {
        return "org.eclipse.core.runtime.adaptor.EclipseStarter";
    }
}

