/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.util.VersionRange;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

class PackageAdminImpl
implements PackageAdmin,
Runnable {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ExportedPackage)o2).getVersion().compareTo(((ExportedPackage)o1).getVersion());
        }
    };
    private Felix m_felix = null;
    private Bundle[][] m_reqBundles = null;
    private Bundle m_systemBundle = null;
    private Thread m_thread = null;

    public PackageAdminImpl(Felix felix) {
        this.m_felix = felix;
        this.m_systemBundle = this.m_felix.getBundle(0L);
        this.m_thread = new Thread((Runnable)this, "FelixPackageAdmin");
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    synchronized void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
            this.notifyAll();
        }
    }

    public Bundle getBundle(Class clazz) {
        return this.m_felix.getBundle(clazz);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange vr = versionRange == null ? null : VersionRange.parse(versionRange);
        Bundle[] bundles = this.m_felix.getBundles();
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            Version v;
            String sym = bundles[i].getSymbolicName();
            if (sym == null || !sym.equals(symbolicName)) continue;
            String s = (String)((FelixBundle)bundles[i]).getInfo().getCurrentHeader().get("Bundle-Version");
            Version version = v = s == null ? new Version("0.0.0") : new Version(s);
            if (vr != null && !vr.isInRange(v)) continue;
            list.add(bundles[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        bundles = list.toArray(new Bundle[list.size()]);
        Arrays.sort(bundles, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)((FelixBundle)o1).getInfo().getCurrentHeader().get("Bundle-Version");
                String s2 = (String)((FelixBundle)o2).getInfo().getCurrentHeader().get("Bundle-Version");
                Version v1 = s1 == null ? new Version("0.0.0") : new Version(s1);
                Version v2 = s2 == null ? new Version("0.0.0") : new Version(s2);
                return v2.compareTo(v1);
            }
        });
        return bundles;
    }

    public int getBundleType(Bundle bundle) {
        return 0;
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] pkgs = this.m_felix.getExportedPackages(name);
        if (pkgs == null || pkgs.length == 0) {
            return null;
        }
        Arrays.sort(pkgs, COMPARATOR);
        return pkgs[0];
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.m_felix.getExportedPackages(name);
        return pkgs == null || pkgs.length == 0 ? null : pkgs;
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        return this.m_felix.getExportedPackages(bundle);
    }

    public synchronized void refreshPackages(Bundle[] bundles) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_systemBundle, "resolve"));
        }
        if (this.m_reqBundles == null) {
            this.m_reqBundles = new Bundle[][]{bundles};
        } else {
            Bundle[][] newReqBundles = new Bundle[this.m_reqBundles.length + 1][];
            System.arraycopy(this.m_reqBundles, 0, newReqBundles, 0, this.m_reqBundles.length);
            newReqBundles[this.m_reqBundles.length] = bundles;
            this.m_reqBundles = newReqBundles;
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Bundle[] bundles = null;
        while (true) {
            PackageAdminImpl packageAdminImpl = this;
            synchronized (packageAdminImpl) {
                while (this.m_reqBundles == null) {
                    if (this.m_thread == null) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                bundles = this.m_reqBundles[0];
            }
            this.m_felix.refreshPackages(bundles);
            packageAdminImpl = this;
            synchronized (packageAdminImpl) {
                if (this.m_reqBundles.length == 1) {
                    this.m_reqBundles = null;
                } else {
                    Bundle[][] newReqBundles = new Bundle[this.m_reqBundles.length - 1][];
                    System.arraycopy(this.m_reqBundles, 1, newReqBundles, 0, this.m_reqBundles.length - 1);
                    this.m_reqBundles = newReqBundles;
                }
            }
        }
    }

    public boolean resolveBundles(Bundle[] bundles) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_systemBundle, "resolve"));
        }
        return this.m_felix.resolveBundles(bundles);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        return null;
    }

    public Bundle[] getFragments(Bundle bundle) {
        return null;
    }

    public Bundle[] getHosts(Bundle bundle) {
        return null;
    }
}

