/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.bayeux;

import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;

abstract class Handshake
extends VerbBase {
    public static final String META_HANDSHAKE = "/meta/handshake";
    private String version = "1.0";
    private String minimumVersion = "0.9";
    private String[] supportedConnectionTypes = new String[]{"long-polling", "callback-polling"};
    private String authScheme = "";
    private String authUser = "";
    protected Boolean authSuccessful = Boolean.TRUE;

    protected Handshake() {
        this.type = Verb.Type.HANDSHAKE;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public void setMinimumVersion(String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public String[] getSupportedConnectionTypes() {
        return this.supportedConnectionTypes;
    }

    public void setSupportedConnectionTypes(String[] supportedConnectionTypes) {
        this.supportedConnectionTypes = supportedConnectionTypes;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public boolean isValid() {
        float ver;
        try {
            ver = Float.parseFloat(this.getVersion());
        }
        catch (Exception ex) {
            return false;
        }
        return ver <= 1.0f && ver >= 0.9f && META_HANDSHAKE.equals(this.getChannel());
    }

    protected String toJSON(boolean isResponse) {
        StringBuilder sb = new StringBuilder(this.getJSONPrefix() + "{" + "\"channel\":\"" + this.channel + "\"" + ",\"version\":\"" + this.version + "\"");
        if (this.supportedConnectionTypes != null) {
            sb.append(",\"supportedConnectionTypes\":[");
            boolean first = true;
            for (String connType : this.supportedConnectionTypes) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append("\"" + connType + "\"");
            }
            sb.append("]");
        }
        if (this.minimumVersion != null) {
            sb.append(",\"minimumVersion\":\"" + this.minimumVersion + "\"");
        }
        if (this.ext != null) {
            sb.append("," + this.ext.toJSON());
        }
        if (this.id != null) {
            sb.append(",\"id\":\"" + this.id + "\"");
        }
        if (isResponse) {
            sb.append(",\"clientId\":\"" + this.clientId + "\"");
            sb.append(",\"successful\":" + this.successful);
            if (this.advice != null) {
                sb.append("," + this.advice.toJSON());
            }
            if (this.authSuccessful != null) {
                sb.append(",\"authSuccessful\":" + this.authSuccessful);
            }
        }
        sb.append("}" + this.getJSONPostfix());
        return sb.toString();
    }

    protected String toErrorResponseJSON() {
        StringBuilder sb = new StringBuilder(this.getJSONPrefix() + "{" + "\"channel\":\"" + this.channel + "\"" + ",\"successful\":" + this.successful + ",\"error\":\"" + this.error + "\"");
        if (this.version != null) {
            sb.append(",\"version\":\"" + this.version + "\"");
        }
        if (this.supportedConnectionTypes != null) {
            sb.append(",\"supportedConnectionTypes\":[");
            boolean first = true;
            for (String connType : this.supportedConnectionTypes) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append("\"" + connType + "\"");
            }
            sb.append("]");
        }
        if (this.minimumVersion != null) {
            sb.append(",\"minimumVersion\":\"" + this.minimumVersion + "\"");
        }
        if (this.ext != null) {
            sb.append("," + this.ext.toJSON());
        }
        if (this.id != null) {
            sb.append(",\"id\":\"" + this.id + "\"");
        }
        if (this.authSuccessful != null) {
            sb.append(",\"authSuccessful\":" + this.authSuccessful);
        }
        sb.append("}" + this.getJSONPostfix());
        return sb.toString();
    }
}

