/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;

public abstract class AbstractIdentityMap
implements IdentityMap,
Serializable,
Cloneable {
    protected int maxSize;
    protected ClassDescriptor descriptor;

    public AbstractIdentityMap() {
    }

    public AbstractIdentityMap(int size) {
        this.maxSize = size;
    }

    public AbstractIdentityMap(int size, ClassDescriptor descriptor) {
        this(size);
        this.descriptor = descriptor;
    }

    public CacheKey acquireDeferredLock(Vector primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        newCacheKey.acquireDeferredLock();
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        newCacheKey.releaseDeferredLock();
        cacheKey.acquireDeferredLock();
        return cacheKey;
    }

    public CacheKey acquireLock(Vector primaryKey, boolean forMerge) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        newCacheKey.acquire(forMerge);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        newCacheKey.release();
        cacheKey.acquire();
        return cacheKey;
    }

    public CacheKey acquireLockNoWait(Vector primaryKey, boolean forMerge) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        newCacheKey.acquire(forMerge);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        newCacheKey.release();
        if (!cacheKey.acquireNoWait(forMerge)) {
            return null;
        }
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKey(newCacheKey);
        if (cacheKey == null) {
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        cacheKey.acquireReadLock();
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKey(newCacheKey);
        if (cacheKey == null) {
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        if (!cacheKey.acquireReadLockNoWait()) {
            return null;
        }
        return cacheKey;
    }

    public abstract void collectLocks(HashMap var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
    }

    public boolean containsKey(Vector primaryKey) {
        return this.getCacheKeyWithReadLock(primaryKey) != null;
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue) {
        return this.createCacheKey(primaryKey, object, writeLockValue, 0L);
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new CacheKey(primaryKey, object, writeLockValue, readTime);
    }

    public abstract Enumeration elements();

    public Object get(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public CacheKey getCacheKey(Vector primaryKey) {
        CacheKey searchKey = new CacheKey(primaryKey);
        return this.getCacheKey(searchKey);
    }

    protected abstract CacheKey getCacheKey(CacheKey var1);

    protected abstract CacheKey getCacheKeyIfAbsentPut(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Vector primaryKey) {
        CacheKey key = this.getCacheKey(primaryKey);
        if (key != null) {
            key.checkReadLock();
        }
        return key;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    public abstract int getSize();

    public abstract int getSize(Class var1, boolean var2);

    public Object getWrapper(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    public Object getWriteLockValue(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    public abstract Enumeration keys();

    public abstract CacheKey put(Vector var1, Object var2, Object var3, long var4);

    public void release() {
    }

    public Object remove(Vector primaryKey, Object object) {
        CacheKey key = this.getCacheKey(primaryKey);
        return this.remove(key);
    }

    public abstract Object remove(CacheKey var1);

    protected synchronized void setMaxSize(int size) {
        this.maxSize = size;
    }

    public void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getDescriptorClass() {
        return this.descriptor.getJavaClass();
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setWrapper(Vector primaryKey, Object wrapper) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWrapper(wrapper);
        }
    }

    public void setWriteLockValue(Vector primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(writeLockValue);
            cacheKey.release();
        }
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "[" + this.getSize() + "]";
    }
}

