/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.Server;

public class SessionFactory {
    private String sessionXMLPath;
    private String sessionName;

    public SessionFactory(String sessionsXMLPath, String sessionName) {
        this.sessionXMLPath = sessionsXMLPath;
        this.sessionName = sessionName;
    }

    public SessionFactory(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSessionXMLPath() {
        return this.sessionXMLPath;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public DatabaseSession getSharedSession() {
        return this.getSharedSession(true, false);
    }

    public DatabaseSession getSharedSession(boolean login, boolean refresh) {
        XMLSessionConfigLoader xmlLoader = this.getSessionXMLPath() != null ? new XMLSessionConfigLoader(this.getSessionXMLPath()) : new XMLSessionConfigLoader();
        return (DatabaseSession)((Object)SessionManager.getManager().getSession(xmlLoader, this.getSessionName(), this.getClassLoader(), login, refresh, true));
    }

    public Session acquireSession() {
        UnitOfWork uow;
        DatabaseSession sharedSession = this.getSharedSession();
        if (sharedSession.hasExternalTransactionController() && (uow = sharedSession.getActiveUnitOfWork()) != null) {
            return uow.getParent();
        }
        if (sharedSession.isServerSession()) {
            return ((Server)sharedSession).acquireClientSession();
        }
        if (sharedSession.isSessionBroker()) {
            SessionBroker broker = (SessionBroker)sharedSession;
            if (broker.isServerSessionBroker()) {
                return broker.acquireClientSessionBroker();
            }
            return broker;
        }
        return sharedSession;
    }

    public UnitOfWork acquireUnitOfWork() {
        return this.acquireUnitOfWork(this.getSharedSession());
    }

    public UnitOfWork acquireUnitOfWork(Session session) {
        if (session.hasExternalTransactionController()) {
            return session.getActiveUnitOfWork();
        }
        return session.acquireUnitOfWork();
    }

    public Object detach(Object entity) {
        UnitOfWorkImpl uow = ((AbstractSession)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork(null);
        Object copy = uow.registerObject(entity);
        uow.release();
        return copy;
    }

    public Collection detach(Collection entities) {
        UnitOfWorkImpl uow = ((AbstractSession)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork(null);
        Vector copies = uow.registerAllObjects(entities);
        uow.release();
        return copies;
    }
}

