/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.interceptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.interceptors.CacheKeyInterceptor;

public abstract class CacheInterceptor
implements IdentityMap {
    protected IdentityMap targetIdentityMap;
    protected AbstractSession interceptedSession;

    public CacheInterceptor(IdentityMap targetIdentityMap, AbstractSession interceptedSession) {
        this.targetIdentityMap = targetIdentityMap;
        this.interceptedSession = interceptedSession;
    }

    public CacheKey acquireDeferredLock(Vector primaryKey) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireDeferredLock(primaryKey));
    }

    public CacheKey acquireLock(Vector primaryKey, boolean forMerge) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireLock(primaryKey, forMerge));
    }

    public CacheKey acquireLockNoWait(Vector primaryKey, boolean forMerge) {
        CacheKey cacheKeyToBeWrapped = this.targetIdentityMap.acquireLockNoWait(primaryKey, forMerge);
        if (cacheKeyToBeWrapped != null) {
            return this.createCacheKeyInterceptor(cacheKeyToBeWrapped);
        }
        return null;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireReadLockOnCacheKey(primaryKey));
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey) {
        CacheKey cacheKeyToBeWrapped = this.targetIdentityMap.acquireReadLockOnCacheKeyNoWait(primaryKey);
        if (cacheKeyToBeWrapped != null) {
            return this.createCacheKeyInterceptor(cacheKeyToBeWrapped);
        }
        return null;
    }

    public void collectLocks(HashMap threadList) {
        this.targetIdentityMap.collectLocks(threadList);
    }

    public abstract Object clone();

    public boolean containsKey(Vector primaryKey) {
        return this.targetIdentityMap.containsKey(primaryKey);
    }

    protected abstract CacheKeyInterceptor createCacheKeyInterceptor(CacheKey var1);

    public Enumeration elements() {
        return this.targetIdentityMap.elements();
    }

    public Object get(Vector primaryKey) {
        return this.targetIdentityMap.get(primaryKey);
    }

    public CacheKey getCacheKey(Vector primaryKey) {
        return this.targetIdentityMap.getCacheKey(primaryKey);
    }

    public ClassDescriptor getDescriptor() {
        return this.targetIdentityMap.getDescriptor();
    }

    public Class getDescriptorClass() {
        return this.targetIdentityMap.getDescriptorClass();
    }

    public int getMaxSize() {
        return this.targetIdentityMap.getMaxSize();
    }

    public int getSize() {
        return this.targetIdentityMap.getSize();
    }

    public int getSize(Class myClass, boolean recurse) {
        return this.targetIdentityMap.getSize(myClass, recurse);
    }

    public IdentityMap getTargetIdenttyMap() {
        return this.targetIdentityMap;
    }

    public Object getWrapper(Vector primaryKey) {
        return this.targetIdentityMap.getWrapper(primaryKey);
    }

    public Object getWriteLockValue(Vector primaryKey) {
        return this.targetIdentityMap.getWriteLockValue(primaryKey);
    }

    public Enumeration keys() {
        return this.targetIdentityMap.keys();
    }

    public CacheKey put(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return this.targetIdentityMap.put(primaryKey, object, writeLockValue, readTime);
    }

    public Object remove(Vector primaryKey, Object object) {
        return this.targetIdentityMap.remove(primaryKey, object);
    }

    public Object remove(CacheKey cacheKey) {
        if (cacheKey.isWrapper()) {
            return this.targetIdentityMap.remove(cacheKey.getWrappedCacheKey());
        }
        return this.targetIdentityMap.remove(cacheKey);
    }

    public void updateMaxSize(int maxSize) {
        this.targetIdentityMap.updateMaxSize(maxSize);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.targetIdentityMap.setDescriptor(descriptor);
    }

    public void setWrapper(Vector primaryKey, Object wrapper) {
        this.targetIdentityMap.setWrapper(primaryKey, wrapper);
    }

    public void setWriteLockValue(Vector primaryKey, Object writeLockValue) {
        this.targetIdentityMap.setWriteLockValue(primaryKey, writeLockValue);
    }

    public String toString() {
        return Helper.getShortClassName("Intercepted " + this.targetIdentityMap.getClass()) + "[" + this.getSize() + "]";
    }
}

