/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSDEPENDSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSDEPENDS";
    protected static final int SYSDEPENDS_COLUMN_COUNT = 4;
    protected static final int SYSDEPENDS_DEPENDENTID = 1;
    protected static final int SYSDEPENDS_DEPENDENTTYPE = 2;
    protected static final int SYSDEPENDS_PROVIDERID = 3;
    protected static final int SYSDEPENDS_PROVIDERTYPE = 4;
    protected static final int SYSDEPENDS_INDEX1_ID = 0;
    protected static final int SYSDEPENDS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{false, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}};
    private static final String[] uuids = new String[]{"8000003e-00d0-fd77-3ed8-000a0a0b1900", "80000043-00d0-fd77-3ed8-000a0a0b1900", "80000040-00d0-fd77-3ed8-000a0a0b1900", "80000042-00d0-fd77-3ed8-000a0a0b1900"};

    public SYSDEPENDSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        DependableFinder dependableFinder = null;
        String string2 = null;
        DependableFinder dependableFinder2 = null;
        if (tupleDescriptor != null) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)tupleDescriptor;
            string = dependencyDescriptor.getUUID().toString();
            dependableFinder = dependencyDescriptor.getDependentFinder();
            if (dependableFinder == null) {
                throw StandardException.newException("XD004.S");
            }
            string2 = dependencyDescriptor.getProviderID().toString();
            dependableFinder2 = dependencyDescriptor.getProviderFinder();
            if (dependableFinder2 == null) {
                throw StandardException.newException("XD004.S");
            }
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(4);
        execRow.setColumn(1, this.dvf.getCharDataValue(string));
        execRow.setColumn(2, this.dvf.getDataValue(dependableFinder));
        execRow.setColumn(3, this.dvf.getCharDataValue(string2));
        execRow.setColumn(4, this.dvf.getDataValue(dependableFinder2));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        Object var4_4 = null;
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        DependableFinder dependableFinder = (DependableFinder)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(3);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(4);
        DependableFinder dependableFinder2 = (DependableFinder)dataValueDescriptor.getObject();
        return new DependencyDescriptor(uUID, dependableFinder, uUID2, dependableFinder2);
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        SystemColumn[] systemColumnArray = new SystemColumn[4];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("DEPENDENTID"), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("DEPENDENTFINDER"), 2, 0, 0, false, "org.apache.derby.catalog.DependableFinder", false, -1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("PROVIDERID"), 3, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("PROVIDERFINDER"), 4, 0, 0, false, "org.apache.derby.catalog.DependableFinder", false, -1);
        return systemColumnArray;
    }
}

