/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.fileStreamer.BaseContext;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletStreamerContext
extends BaseContext {
    public static final String SERVLET_CONFIG = "servletConfig";
    public static final String SERVLET_REQUEST = "servletRequest";
    public static final String SERVLET_RESPONSE = "servletResponse";
    public static final String DEFAULT_DISPOSITION = "attachment";

    public ServletStreamerContext(HttpServletRequest request, HttpServletResponse resp, ServletConfig config) {
        this.setServletRequest(request);
        this.setServletResponse(resp);
        this.setServletConfig(config);
        this.setAttribute("filePath", request.getPathInfo());
    }

    public ContentSource getContentSource() {
        ContentSource src = (ContentSource)this.getAttribute("_contentSource");
        if (src != null) {
            return src;
        }
        String id = this.getServletRequest().getParameter("contentSourceId");
        if (id == null && (id = this.getServletConfig().getInitParameter("contentSourceId")) == null) {
            id = "resourceCS";
        }
        if ((src = FileStreamer.getFileStreamer().getContentSource(id)) == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        this.setAttribute("_contentSource", src);
        return src;
    }

    public void writeHeader(ContentSource source) {
        String contentType;
        HttpServletResponse resp = this.getServletResponse();
        long longTime = source.getLastModified(this);
        if (longTime != -1L) {
            resp.setDateHeader("Last-Modified", longTime);
        }
        if ((contentType = (String)this.getAttribute("ContentType")) == null) {
            String ext = (String)this.getAttribute("extension");
            if (ext != null) {
                contentType = FileStreamer.getMimeType(ext);
            }
            if (contentType == null) {
                contentType = FileStreamer.getDefaultMimeType();
            }
        }
        resp.setHeader("Content-type", contentType);
        String disposition = (String)this.getAttribute("disposition");
        String filename = (String)this.getAttribute("filename");
        if (disposition == null) {
            if (filename != null) {
                resp.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            }
        } else {
            if (filename != null) {
                disposition = disposition + ";filename=\"" + filename + "\"";
            }
            resp.setHeader("Content-Disposition", disposition);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getServletResponse().getOutputStream();
    }

    public ServletConfig getServletConfig() {
        return (ServletConfig)this.getAttribute(SERVLET_CONFIG);
    }

    protected void setServletConfig(ServletConfig config) {
        this.setAttribute(SERVLET_CONFIG, config);
    }

    public HttpServletRequest getServletRequest() {
        return (HttpServletRequest)this.getAttribute(SERVLET_REQUEST);
    }

    protected void setServletRequest(HttpServletRequest request) {
        this.setAttribute(SERVLET_REQUEST, request);
    }

    public HttpServletResponse getServletResponse() {
        return (HttpServletResponse)this.getAttribute(SERVLET_RESPONSE);
    }

    protected void setServletResponse(HttpServletResponse response) {
        this.setAttribute(SERVLET_RESPONSE, response);
    }
}

