/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.B2CConverter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.StringManager;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel {
    private static Logger log = Logger.getLogger(InputBuffer.class.getName());
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int debug = 0;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private boolean closed = false;
    private String enc;
    private boolean gotEnc = false;
    protected HashMap<String, B2CConverter> encoders = new HashMap();
    protected B2CConverter conv;
    private Request coyoteRequest;
    private int markPos = -1;
    private int size = -1;

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int size) {
        this.size = size;
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteInputChannel((ByteChunk.ByteInputChannel)this);
    }

    private void initChar() {
        if (this.cb != null) {
            return;
        }
        this.cb = new CharChunk(this.size);
        this.cb.setLimit(this.size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharInputChannel((CharChunk.CharInputChannel)this);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
    }

    public void setRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
    }

    public Request getRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("recycle()");
        }
        this.state = 0;
        this.cb = null;
        this.bb.recycle();
        this.markPos = -1;
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int available() throws IOException {
        if (this.state == 2) {
            return this.bb.getLength();
        }
        if (this.state == 1) {
            return this.cb.getLength();
        }
        return 0;
    }

    public int realReadBytes(byte[] cbuf, int off, int len) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("realRead() " + this.coyoteRequest);
        }
        if (this.closed) {
            return -1;
        }
        if (this.coyoteRequest == null) {
            return -1;
        }
        this.state = 2;
        int result = this.coyoteRequest.doRead(this.bb);
        return result;
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract(b, off, len);
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        this.initChar();
        this.markPos = -1;
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public int realReadChars(char[] cbuf, int off, int len) throws IOException {
        int nRead;
        this.initChar();
        if (log.isLoggable(Level.FINE)) {
            log.fine("realRead() " + this.cb.getOffset() + " " + len);
        }
        if (!this.gotEnc) {
            this.setConverter();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("encoder:  " + this.conv + " " + this.gotEnc);
        }
        if (this.bb.getLength() <= 0 && (nRead = this.realReadBytes(this.bb.getBytes(), 0, this.bb.getBytes().length)) < 0) {
            return -1;
        }
        if (this.markPos == -1) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        }
        int limit = this.bb.getLength() + this.cb.getStart();
        if (this.cb.getLimit() < limit) {
            this.cb.setLimit(limit);
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb, this.bb.getLength());
        this.bb.setOffset(this.bb.getEnd());
        return this.cb.getLength();
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        this.initChar();
        return this.cb.substract();
    }

    public int read(char[] cbuf) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        this.initChar();
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        this.initChar();
        return this.cb.substract(cbuf, off, len);
    }

    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        this.initChar();
        long nRead = 0L;
        while (nRead < n) {
            if ((long)this.cb.getLength() >= n) {
                this.cb.setOffset(this.cb.getStart() + (int)n);
                nRead = n;
                continue;
            }
            this.cb.setOffset(this.cb.getEnd());
            int toRead = 0;
            toRead = (long)this.cb.getChars().length < n - (nRead += (long)this.cb.getLength()) ? this.cb.getChars().length : (int)(n - nRead);
            int nb = this.realReadChars(this.cb.getChars(), 0, toRead);
            if (nb >= 0) continue;
            break;
        }
        return nRead;
    }

    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        this.initChar();
        return this.cb.getLength() > 0;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.initChar();
        if (this.cb.getLength() <= 0) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else if (this.cb.getBuffer().length > 2 * this.size && this.cb.getLength() < this.cb.getStart()) {
            System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
            this.cb.setEnd(this.cb.getLength());
            this.cb.setOffset(0);
        }
        this.cb.setLimit(this.cb.getStart() + readAheadLimit + this.size);
        this.markPos = this.cb.getStart();
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 1) {
            if (this.markPos < 0) {
                this.cb.recycle();
                this.markPos = -1;
                throw new IOException();
            }
            this.cb.setOffset(this.markPos);
        } else {
            this.bb.recycle();
        }
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    protected void setConverter() throws IOException {
        if (this.coyoteRequest != null) {
            this.enc = this.coyoteRequest.getCharacterEncoding();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Got encoding: " + this.enc);
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = DEFAULT_ENCODING;
        }
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    this.conv = AccessController.doPrivileged(new PrivilegedExceptionAction<B2CConverter>(){

                        @Override
                        public B2CConverter run() throws IOException {
                            return new B2CConverter(InputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("setConverter: " + ex.getMessage());
                    }
                }
            } else {
                this.conv = new B2CConverter(this.enc);
            }
            this.encoders.put(this.enc, this.conv);
        }
    }
}

