/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import com.sun.appserv.management.util.jmx.stringifier.MBeanAttributeInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanConstructorInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanFeatureInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanFeatureInfoStringifierOptions;
import com.sun.appserv.management.util.jmx.stringifier.MBeanNotificationInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanOperationInfoStringifier;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.appserv.management.util.stringifier.Stringifier;
import javax.management.MBeanInfo;

public class MBeanInfoStringifier
extends MBeanFeatureInfoStringifier
implements Stringifier {
    public static final MBeanInfoStringifier DEFAULT = new MBeanInfoStringifier();

    public MBeanInfoStringifier() {
    }

    public MBeanInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        super(options);
    }

    private String stringifyArray(Object[] a, Stringifier stringifier) {
        String temp = "";
        if (a.length != 0) {
            temp = "\n" + ArrayStringifier.stringify(a, "\n", stringifier);
        }
        return temp;
    }

    MBeanAttributeInfoStringifier getMBeanAttributeInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanAttributeInfoStringifier(options);
    }

    MBeanOperationInfoStringifier getMBeanOperationInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanOperationInfoStringifier(options);
    }

    MBeanConstructorInfoStringifier getMBeanConstructorInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanConstructorInfoStringifier(options);
    }

    MBeanNotificationInfoStringifier getMBeanNotificationInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanNotificationInfoStringifier(options);
    }

    public String stringify(Object o) {
        String result = "";
        MBeanInfo info = (MBeanInfo)o;
        Object[] operations = info.getOperations();
        Object[] attributes = info.getAttributes();
        Object[] constructors = info.getConstructors();
        Object[] notifications = info.getNotifications();
        String description = info.getDescription();
        result = "Summary: " + operations.length + " operations, " + attributes.length + " attributes, " + constructors.length + " constructors, " + notifications.length + " notifications" + (description == null ? "" : ", \"" + description + "\"");
        MBeanFeatureInfoStringifierOptions options = new MBeanFeatureInfoStringifierOptions(true, ",");
        result = result + "\n\n- Attributes -" + this.stringifyArray(attributes, this.getMBeanAttributeInfoStringifier(options));
        result = result + "\n\n- Operations -" + this.stringifyArray(operations, this.getMBeanOperationInfoStringifier(options));
        result = result + "\n\n- Constructors -" + this.stringifyArray(constructors, this.getMBeanConstructorInfoStringifier(options));
        result = result + "\n\n- Notifications -" + this.stringifyArray(notifications, this.getMBeanNotificationInfoStringifier(options));
        return result;
    }
}

